/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.window.WindowFunction;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.Iterables;
import java.util.List;

public class FirstValueFunction
implements WindowFunction {
    private final Type type;
    private final int argumentChannel;
    private int rowCount;
    private PagesIndex pagesIndex;
    private int valuePosition;

    protected FirstValueFunction(Type type, List<Integer> argumentChannels) {
        this.type = type;
        this.argumentChannel = (Integer)Iterables.getOnlyElement(argumentChannels);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void reset(int partitionRowCount, PagesIndex pagesIndex) {
        this.pagesIndex = pagesIndex;
        this.valuePosition = this.rowCount;
        this.rowCount += partitionRowCount;
    }

    @Override
    public void processRow(BlockBuilder output, boolean newPeerGroup, int peerGroupCount) {
        this.pagesIndex.appendTo(this.argumentChannel, this.valuePosition, output);
    }

    public static class VarcharFirstValueFunction
    extends FirstValueFunction {
        public VarcharFirstValueFunction(List<Integer> argumentChannels) {
            super((Type)VarcharType.VARCHAR, argumentChannels);
        }
    }

    public static class DoubleFirstValueFunction
    extends FirstValueFunction {
        public DoubleFirstValueFunction(List<Integer> argumentChannels) {
            super((Type)DoubleType.DOUBLE, argumentChannels);
        }
    }

    public static class BooleanFirstValueFunction
    extends FirstValueFunction {
        public BooleanFirstValueFunction(List<Integer> argumentChannels) {
            super((Type)BooleanType.BOOLEAN, argumentChannels);
        }
    }

    public static class BigintFirstValueFunction
    extends FirstValueFunction {
        public BigintFirstValueFunction(List<Integer> argumentChannels) {
            super((Type)BigintType.BIGINT, argumentChannels);
        }
    }
}

