/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.ScalarFunction;
import com.facebook.presto.type.SqlType;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class VarbinaryFunctions {
    private VarbinaryFunctions() {
    }

    @Description(value="length of the given binary")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long length(@SqlType(value="varbinary") Slice slice) {
        return slice.length();
    }

    @Description(value="encode binary data as base64")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice toBase64(@SqlType(value="varbinary") Slice slice) {
        return Slices.utf8Slice((String)BaseEncoding.base64().encode(slice.getBytes()));
    }

    @Description(value="decode base64 encoded binary data")
    @ScalarFunction(value="from_base64")
    @SqlType(value="varbinary")
    public static Slice fromBase64Varchar(@SqlType(value="varchar") Slice slice) {
        return Slices.wrappedBuffer((byte[])BaseEncoding.base64().decode((CharSequence)slice.toStringUtf8()));
    }

    @Description(value="decode base64 encoded binary data")
    @ScalarFunction(value="from_base64")
    @SqlType(value="varbinary")
    public static Slice fromBase64Varbinary(@SqlType(value="varbinary") Slice slice) {
        return Slices.wrappedBuffer((byte[])BaseEncoding.base64().decode((CharSequence)slice.toStringUtf8()));
    }

    @Description(value="encode binary data as base64 using the URL safe alphabet")
    @ScalarFunction(value="to_base64url")
    @SqlType(value="varchar")
    public static Slice toBase64Url(@SqlType(value="varbinary") Slice slice) {
        return Slices.utf8Slice((String)BaseEncoding.base64Url().encode(slice.getBytes()));
    }

    @Description(value="decode URL safe base64 encoded binary data")
    @ScalarFunction(value="from_base64url")
    @SqlType(value="varbinary")
    public static Slice fromBase64UrlVarchar(@SqlType(value="varchar") Slice slice) {
        return Slices.wrappedBuffer((byte[])BaseEncoding.base64Url().decode((CharSequence)slice.toStringUtf8()));
    }

    @Description(value="decode URL safe base64 encoded binary data")
    @ScalarFunction(value="from_base64url")
    @SqlType(value="varbinary")
    public static Slice fromBase64UrlVarbinary(@SqlType(value="varbinary") Slice slice) {
        return Slices.wrappedBuffer((byte[])BaseEncoding.base64Url().decode((CharSequence)slice.toStringUtf8()));
    }

    @Description(value="encode binary data as hex")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice toHex(@SqlType(value="varbinary") Slice slice) {
        return Slices.utf8Slice((String)BaseEncoding.base16().encode(slice.getBytes()));
    }

    @Description(value="decode hex encoded binary data")
    @ScalarFunction(value="from_hex")
    @SqlType(value="varbinary")
    public static Slice fromHexVarchar(@SqlType(value="varchar") Slice slice) {
        return Slices.wrappedBuffer((byte[])BaseEncoding.base16().decode((CharSequence)slice.toStringUtf8()));
    }

    @Description(value="decode hex encoded binary data")
    @ScalarFunction(value="from_hex")
    @SqlType(value="varbinary")
    public static Slice fromHexVarbinary(@SqlType(value="varbinary") Slice slice) {
        return Slices.wrappedBuffer((byte[])BaseEncoding.base16().decode((CharSequence)slice.toStringUtf8()));
    }
}

