/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.metadata.FunctionInfo;
import com.facebook.presto.metadata.ParametricScalar;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeParameter;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.gen.ByteCodeUtils;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.sql.relational.Signatures;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ArrayConstructor
extends ParametricScalar {
    public static final ArrayConstructor ARRAY_CONSTRUCTOR;
    private static final Signature SIGNATURE;
    private static final MethodHandle EMPTY_ARRAY_CONSTRUCTOR;

    @Override
    public Signature getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public FunctionInfo specialize(Map<String, Type> types, int arity, TypeManager typeManager) {
        MethodHandle methodHandle;
        if (types.isEmpty()) {
            return new FunctionInfo(Signatures.arrayConstructorSignature(TypeUtils.parameterizedTypeName("array", "unknown"), (List<String>)ImmutableList.of()), "", true, EMPTY_ARRAY_CONSTRUCTOR, true, false, (List<Boolean>)ImmutableList.of());
        }
        Preconditions.checkArgument((types.size() == 1 ? 1 : 0) != 0, (Object)"Can only construct arrays from exactly matching types");
        ImmutableList.Builder builder = ImmutableList.builder();
        Type type = types.get("E");
        for (int i = 0; i < arity; ++i) {
            if (type.getJavaType().isPrimitive()) {
                builder.add((Object)Primitives.wrap((Class)type.getJavaType()));
                continue;
            }
            builder.add((Object)type.getJavaType());
        }
        ImmutableList stackTypes = builder.build();
        Class<?> clazz = ArrayConstructor.generateArrayConstructor(stackTypes, type);
        try {
            Method method = clazz.getMethod("arrayConstructor", (Class[])stackTypes.toArray((Object[])new Class[stackTypes.size()]));
            methodHandle = MethodHandles.lookup().unreflect(method);
        }
        catch (ReflectiveOperationException e) {
            throw Throwables.propagate((Throwable)e);
        }
        ImmutableList nullableParameters = ImmutableList.copyOf(Collections.nCopies(stackTypes.size(), true));
        return new FunctionInfo(Signatures.arrayConstructorSignature(TypeUtils.parameterizedTypeName("array", type.getName()), Collections.nCopies(arity, type.getName())), "Constructs an array of the given elements", true, methodHandle, true, false, (List<Boolean>)nullableParameters);
    }

    public static Slice emptyArrayConstructor() {
        return ArrayType.toStackRepresentation(ImmutableList.of());
    }

    private static Class<?> generateArrayConstructor(List<Class<?>> stackTypes, Type elementType) {
        ImmutableList stackTypeNames = FluentIterable.from(stackTypes).transform(new Function<Class<?>, String>(){

            public String apply(Class<?> input) {
                return input.getSimpleName();
            }
        }).toList();
        ClassDefinition definition = new ClassDefinition(new CompilerContext(null), Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName(Joiner.on((String)"").join((Iterable)stackTypeNames) + "ArrayConstructor"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a(Access.PRIVATE));
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (int i = 0; i < stackTypes.size(); ++i) {
            Class<?> stackType = stackTypes.get(i);
            parameters.add((Object)NamedParameterDefinition.arg("arg" + i, stackType));
        }
        CompilerContext context = new CompilerContext(null);
        Block body = definition.declareMethod(context, Access.a(Access.PUBLIC, Access.STATIC), "arrayConstructor", ParameterizedType.type(Slice.class), (Iterable<NamedParameterDefinition>)parameters.build()).getBody();
        Variable valuesVariable = context.declareVariable(List.class, "values");
        body.comment("List<Object> values = new ArrayList();").newObject(ArrayList.class).dup().invokeConstructor(ArrayList.class, new Class[0]).putVariable(valuesVariable);
        for (int i = 0; i < stackTypes.size(); ++i) {
            body.comment("values.add(arg" + i + ");").getVariable(valuesVariable).getVariable("arg" + i);
            Class<?> stackType = stackTypes.get(i);
            if (stackType.isPrimitive()) {
                body.append(ByteCodeUtils.boxPrimitiveIfNecessary(context, stackType));
            }
            body.invokeInterface(List.class, "add", Boolean.TYPE, Object.class);
        }
        if (elementType instanceof ArrayType || elementType instanceof MapType) {
            body.comment("return rawSlicesToStackRepresentation(values);").getVariable(valuesVariable).invokeStatic(ArrayType.class, "rawSlicesToStackRepresentation", Slice.class, List.class).retObject();
        } else {
            body.comment("return toStackRepresentation(values);").getVariable(valuesVariable).invokeStatic(ArrayType.class, "toStackRepresentation", Slice.class, List.class).retObject();
        }
        return CompilerUtils.defineClass(definition, Object.class, new DynamicClassLoader());
    }

    static {
        MethodHandle methodHandle;
        ARRAY_CONSTRUCTOR = new ArrayConstructor();
        SIGNATURE = new Signature("array_constructor", (List<TypeParameter>)ImmutableList.of((Object)Signature.typeParameter("E")), "array<E>", (List<String>)ImmutableList.of((Object)"E"), true, true);
        try {
            methodHandle = MethodHandles.lookup().unreflect(ArrayConstructor.class.getMethod("emptyArrayConstructor", new Class[0]));
        }
        catch (ReflectiveOperationException e) {
            throw Throwables.propagate((Throwable)e);
        }
        EMPTY_ARRAY_CONSTRUCTOR = methodHandle;
    }
}

