/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.index.IndexSnapshot;
import com.facebook.presto.spi.block.Block;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class UpdateRequest {
    private final Block[] blocks;
    private final AtomicReference<IndexSnapshot> indexSnapshotReference = new AtomicReference();

    public UpdateRequest(Block ... blocks) {
        this.blocks = (Block[])Preconditions.checkNotNull((Object)blocks, (Object)"blocks is null");
    }

    public Block[] getBlocks() {
        return this.blocks;
    }

    public void finished(IndexSnapshot indexSnapshot) {
        Preconditions.checkNotNull((Object)indexSnapshot, (Object)"indexSnapshot is null");
        Preconditions.checkState((boolean)this.indexSnapshotReference.compareAndSet(null, indexSnapshot), (Object)"Already finished!");
    }

    public boolean isFinished() {
        return this.indexSnapshotReference.get() != null;
    }

    public IndexSnapshot getFinishedIndexSnapshot() {
        IndexSnapshot indexSnapshot = this.indexSnapshotReference.get();
        Preconditions.checkState((indexSnapshot != null ? 1 : 0) != 0, (Object)"Update request is not finished");
        return indexSnapshot;
    }
}

