/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.FinishedOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PageSourceOperator;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.operator.index.IndexSplit;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.Index;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.util.Types;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public class IndexSourceOperator
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final PlanNodeId planNodeId;
    private final Index index;
    private final List<Type> types;
    private final Function<RecordSet, RecordSet> probeKeyNormalizer;
    @GuardedBy(value="this")
    private Operator source;

    public IndexSourceOperator(OperatorContext operatorContext, PlanNodeId planNodeId, Index index, List<Type> types, Function<RecordSet, RecordSet> probeKeyNormalizer) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.planNodeId = (PlanNodeId)Preconditions.checkNotNull((Object)planNodeId, (Object)"planNodeId is null");
        this.index = (Index)Preconditions.checkNotNull((Object)index, (Object)"index is null");
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.probeKeyNormalizer = (Function)Preconditions.checkNotNull(probeKeyNormalizer, (Object)"probeKeyNormalizer is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.planNodeId;
    }

    @Override
    public synchronized void addSplit(Split split) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Types.checkType(split.getConnectorSplit(), IndexSplit.class, "connectorSplit");
        Preconditions.checkState((this.getSource() == null ? 1 : 0) != 0, (Object)"Index source split already set");
        IndexSplit indexSplit = (IndexSplit)split.getConnectorSplit();
        RecordSet normalizedRecordSet = (RecordSet)this.probeKeyNormalizer.apply((Object)indexSplit.getKeyRecordSet());
        RecordSet result = this.index.lookup(normalizedRecordSet);
        this.source = new PageSourceOperator((ConnectorPageSource)new RecordPageSource(result), result.getColumnTypes(), this.operatorContext);
        this.operatorContext.setInfoSupplier((Supplier<Object>)Suppliers.ofInstance((Object)split.getInfo()));
    }

    @Override
    public synchronized void noMoreSplits() {
        if (this.source == null) {
            this.source = new FinishedOperator(this.operatorContext, this.types);
        }
    }

    private synchronized Operator getSource() {
        return this.source;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        Operator delegate;
        IndexSourceOperator indexSourceOperator = this;
        synchronized (indexSourceOperator) {
            delegate = this.getSource();
            if (delegate == null) {
                this.source = new FinishedOperator(this.operatorContext, this.types);
                return;
            }
        }
        delegate.finish();
    }

    @Override
    public boolean isFinished() {
        Operator delegate = this.getSource();
        return delegate != null && delegate.isFinished();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " can not take input");
    }

    @Override
    public Page getOutput() {
        Operator delegate = this.getSource();
        if (delegate == null) {
            return null;
        }
        return delegate.getOutput();
    }

    public static class IndexSourceOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final Index index;
        private final List<Type> types;
        private final Function<RecordSet, RecordSet> probeKeyNormalizer;
        private boolean closed;

        public IndexSourceOperatorFactory(int operatorId, PlanNodeId sourceId, Index index, List<Type> types, Function<RecordSet, RecordSet> probeKeyNormalizer) {
            this.operatorId = operatorId;
            this.sourceId = (PlanNodeId)Preconditions.checkNotNull((Object)sourceId, (Object)"sourceId is null");
            this.index = (Index)Preconditions.checkNotNull((Object)index, (Object)"index is null");
            this.types = (List)Preconditions.checkNotNull(types, (Object)"types is null");
            this.probeKeyNormalizer = (Function)Preconditions.checkNotNull(probeKeyNormalizer, (Object)"probeKeyNormalizer is null");
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, IndexSourceOperator.class.getSimpleName());
            return new IndexSourceOperator(operatorContext, this.sourceId, this.index, this.types, this.probeKeyNormalizer);
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

