/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.operator.aggregation.state.NullableBigintState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;

public class NullableBigintStateSerializer
implements AccumulatorStateSerializer<NullableBigintState> {
    @Override
    public Type getSerializedType() {
        return BigintType.BIGINT;
    }

    @Override
    public void serialize(NullableBigintState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            BigintType.BIGINT.writeLong(out, state.getLong());
        }
    }

    @Override
    public void deserialize(Block block, int index, NullableBigintState state) {
        state.setNull(block.isNull(index));
        if (!state.isNull()) {
            state.setLong(BigintType.BIGINT.getLong(block, index));
        }
    }
}

