/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.MaxByState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.array.BlockBigArray;

public class MaxByStateFactory
implements AccumulatorStateFactory<MaxByState> {
    private final Type valueType;
    private final Type keyType;

    public MaxByStateFactory(Type valueType, Type keyType) {
        this.valueType = valueType;
        this.keyType = keyType;
    }

    @Override
    public MaxByState createSingleState() {
        return new SingleMaxByState(this.keyType, this.valueType);
    }

    @Override
    public Class<? extends MaxByState> getSingleStateClass() {
        return SingleMaxByState.class;
    }

    @Override
    public MaxByState createGroupedState() {
        return new GroupedMaxByState(this.keyType, this.valueType);
    }

    @Override
    public Class<? extends MaxByState> getGroupedStateClass() {
        return GroupedMaxByState.class;
    }

    public static class SingleMaxByState
    implements MaxByState {
        private final Type keyType;
        private final Type valueType;
        private Block key;
        private Block value;

        public SingleMaxByState(Type keyType, Type valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public long getEstimatedSize() {
            long size = 0L;
            if (this.key != null) {
                size += (long)this.key.getSizeInBytes();
            }
            if (this.value != null) {
                size += (long)this.value.getSizeInBytes();
            }
            return size;
        }

        @Override
        public Type getKeyType() {
            return this.keyType;
        }

        @Override
        public Type getValueType() {
            return this.valueType;
        }

        @Override
        public Block getKey() {
            return this.key;
        }

        @Override
        public void setKey(Block key) {
            this.key = key;
        }

        @Override
        public Block getValue() {
            return this.value;
        }

        @Override
        public void setValue(Block value) {
            this.value = value;
        }
    }

    public static class GroupedMaxByState
    extends AbstractGroupedAccumulatorState
    implements MaxByState {
        private final Type keyType;
        private final Type valueType;
        private final BlockBigArray keys = new BlockBigArray();
        private final BlockBigArray values = new BlockBigArray();

        public GroupedMaxByState(Type keyType, Type valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        @Override
        public void ensureCapacity(long size) {
            this.keys.ensureCapacity(size);
            this.values.ensureCapacity(size);
        }

        @Override
        public long getEstimatedSize() {
            return this.keys.sizeOf() + this.values.sizeOf();
        }

        @Override
        public Type getKeyType() {
            return this.keyType;
        }

        @Override
        public Type getValueType() {
            return this.valueType;
        }

        @Override
        public Block getKey() {
            return this.keys.get(this.getGroupId());
        }

        @Override
        public void setKey(Block key) {
            this.keys.set(this.getGroupId(), key);
        }

        @Override
        public Block getValue() {
            return this.values.get(this.getGroupId());
        }

        @Override
        public void setValue(Block value) {
            this.values.set(this.getGroupId(), value);
        }
    }
}

