/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.HyperLogLogState;
import com.facebook.presto.util.array.ObjectBigArray;
import com.google.common.base.Preconditions;
import io.airlift.stats.cardinality.HyperLogLog;

public class HyperLogLogStateFactory
implements AccumulatorStateFactory<HyperLogLogState> {
    @Override
    public HyperLogLogState createSingleState() {
        return new SingleHyperLogLogState();
    }

    @Override
    public Class<? extends HyperLogLogState> getSingleStateClass() {
        return SingleHyperLogLogState.class;
    }

    @Override
    public HyperLogLogState createGroupedState() {
        return new GroupedHyperLogLogState();
    }

    @Override
    public Class<? extends HyperLogLogState> getGroupedStateClass() {
        return GroupedHyperLogLogState.class;
    }

    public static class SingleHyperLogLogState
    implements HyperLogLogState {
        private HyperLogLog hll;

        @Override
        public HyperLogLog getHyperLogLog() {
            return this.hll;
        }

        @Override
        public void setHyperLogLog(HyperLogLog value) {
            this.hll = value;
        }

        @Override
        public void addMemoryUsage(int value) {
        }

        @Override
        public long getEstimatedSize() {
            if (this.hll == null) {
                return 0L;
            }
            return this.hll.estimatedInMemorySize();
        }
    }

    public static class GroupedHyperLogLogState
    extends AbstractGroupedAccumulatorState
    implements HyperLogLogState {
        private final ObjectBigArray<HyperLogLog> hlls = new ObjectBigArray();
        private long size;

        @Override
        public void ensureCapacity(long size) {
            this.hlls.ensureCapacity(size);
        }

        @Override
        public HyperLogLog getHyperLogLog() {
            return this.hlls.get(this.getGroupId());
        }

        @Override
        public void setHyperLogLog(HyperLogLog value) {
            Preconditions.checkNotNull((Object)value, (Object)"value is null");
            this.hlls.set(this.getGroupId(), value);
        }

        @Override
        public void addMemoryUsage(int value) {
            this.size += (long)value;
        }

        @Override
        public long getEstimatedSize() {
            return this.size + this.hlls.sizeOf();
        }
    }
}

