/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.metadata.FunctionFactory;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.metadata.ParametricFunction;
import com.facebook.presto.operator.aggregation.AggregationCompiler;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class GenericAggregationFunctionFactory
implements FunctionFactory {
    private final List<ParametricFunction> aggregations;

    public static GenericAggregationFunctionFactory fromAggregationDefinition(Class<?> clazz, TypeManager typeManager) {
        FunctionListBuilder builder = new FunctionListBuilder(typeManager);
        for (InternalAggregationFunction aggregation : new AggregationCompiler(typeManager).generateAggregationFunctions(clazz)) {
            builder.aggregate(aggregation);
        }
        return new GenericAggregationFunctionFactory(builder.getFunctions());
    }

    private GenericAggregationFunctionFactory(List<ParametricFunction> aggregations) {
        this.aggregations = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(aggregations, (Object)"aggregations is null")));
    }

    @Override
    public List<ParametricFunction> listFunctions() {
        return this.aggregations;
    }
}

