/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.IntermediateInputFunction;
import com.facebook.presto.operator.aggregation.state.InitialDoubleValue;
import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.type.SqlType;

@AggregationFunction(value="max")
public final class DoubleMaxAggregation {
    private DoubleMaxAggregation() {
    }

    @InputFunction
    @IntermediateInputFunction
    public static void max(DoubleMaxState state, @SqlType(value="double") double value) {
        state.setNull(false);
        state.setDouble(Math.max(state.getDouble(), value));
    }

    public static interface DoubleMaxState
    extends NullableDoubleState {
        @Override
        @InitialDoubleValue(value=-Infinity)
        public double getDouble();
    }
}

