/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.byteCode.Access;
import com.facebook.presto.byteCode.ClassDefinition;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.DynamicClassLoader;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.MethodDefinition;
import com.facebook.presto.byteCode.NamedParameterDefinition;
import com.facebook.presto.byteCode.OpCode;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.Variable;
import com.facebook.presto.byteCode.control.ForLoop;
import com.facebook.presto.byteCode.control.IfStatement;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AggregationMetadata;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactoryBinder;
import com.facebook.presto.operator.aggregation.GroupedAccumulator;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateSerializer;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CompilerOperations;
import com.facebook.presto.sql.gen.CompilerUtils;
import com.facebook.presto.sql.gen.SqlTypeByteCodeExpression;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class AccumulatorCompiler {
    public GenericAccumulatorFactoryBinder generateAccumulatorFactoryBinder(AggregationMetadata metadata, DynamicClassLoader classLoader) {
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new GenericAccumulatorFactoryBinder(metadata.getStateSerializer(), metadata.getStateFactory(), accumulatorClass, groupedAccumulatorClass, metadata.isApproximate());
    }

    private static <T> Class<? extends T> generateAccumulatorClass(Class<T> accumulatorInterface, AggregationMetadata metadata, DynamicClassLoader classLoader) {
        boolean grouped = accumulatorInterface == GroupedAccumulator.class;
        boolean approximate = metadata.isApproximate();
        ClassDefinition definition = new ClassDefinition(Access.a(Access.PUBLIC, Access.FINAL), CompilerUtils.makeClassName(metadata.getName() + accumulatorInterface.getSimpleName()), ParameterizedType.type(Object.class), ParameterizedType.type(accumulatorInterface));
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        AccumulatorStateSerializer<?> stateSerializer = metadata.getStateSerializer();
        AccumulatorStateFactory<?> stateFactory = metadata.getStateFactory();
        FieldDefinition stateSerializerField = definition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "stateSerializer", AccumulatorStateSerializer.class);
        FieldDefinition stateFactoryField = definition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "stateFactory", AccumulatorStateFactory.class);
        FieldDefinition inputChannelsField = definition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "inputChannels", ParameterizedType.type(List.class, Integer.class));
        FieldDefinition maskChannelField = definition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "maskChannel", ParameterizedType.type(Optional.class, Integer.class));
        FieldDefinition sampleWeightChannelField = null;
        FieldDefinition confidenceField = null;
        if (approximate) {
            sampleWeightChannelField = definition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "sampleWeightChannel", ParameterizedType.type(Optional.class, Integer.class));
            confidenceField = definition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "confidence", Double.TYPE);
        }
        FieldDefinition stateField = definition.declareField(Access.a(Access.PRIVATE, Access.FINAL), "state", grouped ? stateFactory.getGroupedStateClass() : stateFactory.getSingleStateClass());
        AccumulatorCompiler.generateConstructor(definition, stateSerializerField, stateFactoryField, inputChannelsField, maskChannelField, sampleWeightChannelField, confidenceField, stateField, grouped);
        AccumulatorCompiler.generateAddInput(definition, stateField, inputChannelsField, maskChannelField, sampleWeightChannelField, metadata.getInputMetadata(), metadata.getInputFunction(), callSiteBinder, grouped);
        AccumulatorCompiler.generateGetEstimatedSize(definition, stateField);
        MethodDefinition getIntermediateType = AccumulatorCompiler.generateGetIntermediateType(definition, callSiteBinder, stateSerializer.getSerializedType());
        MethodDefinition getFinalType = AccumulatorCompiler.generateGetFinalType(definition, callSiteBinder, metadata.getOutputType());
        if (metadata.getIntermediateInputFunction() == null) {
            AccumulatorCompiler.generateAddIntermediateAsCombine(definition, stateField, stateSerializerField, stateFactoryField, metadata.getCombineFunction(), stateFactory.getSingleStateClass(), grouped);
        } else {
            AccumulatorCompiler.generateAddIntermediateAsIntermediateInput(definition, stateField, metadata.getIntermediateInputMetadata(), metadata.getIntermediateInputFunction(), callSiteBinder, grouped);
        }
        if (grouped) {
            AccumulatorCompiler.generateGroupedEvaluateIntermediate(definition, stateSerializerField, stateField);
        } else {
            AccumulatorCompiler.generateEvaluateIntermediate(definition, getIntermediateType, stateSerializerField, stateField);
        }
        if (grouped) {
            AccumulatorCompiler.generateGroupedEvaluateFinal(definition, confidenceField, stateSerializerField, stateField, metadata.getOutputFunction(), metadata.isApproximate());
        } else {
            AccumulatorCompiler.generateEvaluateFinal(definition, getFinalType, confidenceField, stateSerializerField, stateField, metadata.getOutputFunction(), metadata.isApproximate());
        }
        return CompilerUtils.defineClass(definition, accumulatorInterface, callSiteBinder.getBindings(), classLoader);
    }

    private static MethodDefinition generateGetIntermediateType(ClassDefinition definition, CallSiteBinder callSiteBinder, Type type) {
        MethodDefinition methodDefinition = definition.declareMethod(Access.a(Access.PUBLIC), "getIntermediateType", ParameterizedType.type(Type.class), new NamedParameterDefinition[0]);
        methodDefinition.getBody().append(SqlTypeByteCodeExpression.constantType(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), callSiteBinder, type)).retObject();
        return methodDefinition;
    }

    private static MethodDefinition generateGetFinalType(ClassDefinition definition, CallSiteBinder callSiteBinder, Type type) {
        MethodDefinition methodDefinition = definition.declareMethod(Access.a(Access.PUBLIC), "getFinalType", ParameterizedType.type(Type.class), new NamedParameterDefinition[0]);
        methodDefinition.getBody().append(SqlTypeByteCodeExpression.constantType(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), callSiteBinder, type)).retObject();
        return methodDefinition;
    }

    private static void generateGetEstimatedSize(ClassDefinition definition, FieldDefinition stateField) {
        definition.declareMethod(Access.a(Access.PUBLIC), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new NamedParameterDefinition[0]).getBody().pushThis().getField(stateField).invokeVirtual(stateField.getType(), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new ParameterizedType[0]).retLong();
    }

    private static void generateAddInput(ClassDefinition definition, FieldDefinition stateField, FieldDefinition inputChannelsField, FieldDefinition maskChannelField, @Nullable FieldDefinition sampleWeightChannelField, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, Method inputFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        CompilerContext context = new CompilerContext();
        ImmutableList.Builder parameters = ImmutableList.builder();
        if (grouped) {
            parameters.add((Object)NamedParameterDefinition.arg("groupIdsBlock", GroupByIdBlock.class));
        }
        parameters.add((Object)NamedParameterDefinition.arg("page", Page.class));
        com.facebook.presto.byteCode.Block body = definition.declareMethod(context, Access.a(Access.PUBLIC), "addInput", ParameterizedType.type(Void.TYPE), (Iterable<NamedParameterDefinition>)parameters.build()).getBody();
        if (grouped) {
            AccumulatorCompiler.generateEnsureCapacity(stateField, body);
        }
        ArrayList<Variable> parameterVariables = new ArrayList<Variable>();
        for (int i = 0; i < AggregationMetadata.countInputChannels(parameterMetadatas); ++i) {
            parameterVariables.add(context.declareVariable(Block.class, "block" + i));
        }
        Variable masksBlock = context.declareVariable(Block.class, "masksBlock");
        Variable sampleWeightsBlock = null;
        if (sampleWeightChannelField != null) {
            sampleWeightsBlock = context.declareVariable(Block.class, "sampleWeightsBlock");
        }
        body.comment("masksBlock = maskChannel.transform(page.blockGetter()).orNull();").pushThis().getField(maskChannelField).getVariable("page").invokeStatic(ParameterizedType.type(AggregationUtils.class), "pageBlockGetter", ParameterizedType.type(Function.class, Integer.class, Block.class), ParameterizedType.type(Page.class)).invokeVirtual(Optional.class, "transform", Optional.class, Function.class).invokeVirtual(Optional.class, "orNull", Object.class, new Class[0]).checkCast(Block.class).putVariable(masksBlock);
        if (sampleWeightChannelField != null) {
            body.comment("sampleWeightsBlock = sampleWeightChannel.transform(page.blockGetter()).get();").pushThis().getField(sampleWeightChannelField).getVariable("page").invokeStatic(ParameterizedType.type(AggregationUtils.class), "pageBlockGetter", ParameterizedType.type(Function.class, Integer.class, Block.class), ParameterizedType.type(Page.class)).invokeVirtual(Optional.class, "transform", Optional.class, Function.class).invokeVirtual(Optional.class, "get", Object.class, new Class[0]).checkCast(Block.class).putVariable(sampleWeightsBlock);
        }
        for (int i = 0; i < AggregationMetadata.countInputChannels(parameterMetadatas); ++i) {
            body.comment("%s = page.getBlock(inputChannels.get(%d));", ((Variable)parameterVariables.get(i)).getName(), i).getVariable("page").pushThis().getField(inputChannelsField).push(i).invokeInterface(List.class, "get", Object.class, Integer.TYPE).checkCast(Integer.class).invokeVirtual(Integer.class, "intValue", Integer.TYPE, new Class[0]).invokeVirtual(Page.class, "getBlock", Block.class, Integer.TYPE).putVariable((Variable)parameterVariables.get(i));
        }
        com.facebook.presto.byteCode.Block block = AccumulatorCompiler.generateInputForLoop(stateField, parameterMetadatas, inputFunction, context, parameterVariables, masksBlock, sampleWeightsBlock, callSiteBinder, grouped);
        body.append(block).ret();
    }

    private static com.facebook.presto.byteCode.Block generateInputForLoop(FieldDefinition stateField, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, Method inputFunction, CompilerContext context, List<Variable> parameterVariables, Variable masksBlock, @Nullable Variable sampleWeightsBlock, CallSiteBinder callSiteBinder, boolean grouped) {
        Variable positionVariable = context.declareVariable(Integer.TYPE, "position");
        Variable sampleWeightVariable = null;
        if (sampleWeightsBlock != null) {
            sampleWeightVariable = context.declareVariable(Long.TYPE, "sampleWeight");
        }
        Variable rowsVariable = context.declareVariable(Integer.TYPE, "rows");
        com.facebook.presto.byteCode.Block block = new com.facebook.presto.byteCode.Block(context).getVariable("page").invokeVirtual(Page.class, "getPositionCount", Integer.TYPE, new Class[0]).putVariable(rowsVariable).initializeVariable(positionVariable);
        if (sampleWeightVariable != null) {
            block.initializeVariable(sampleWeightVariable);
        }
        com.facebook.presto.byteCode.Block loopBody = AccumulatorCompiler.generateInvokeInputFunction(context, stateField, positionVariable, sampleWeightVariable, parameterVariables, parameterMetadatas, inputFunction, callSiteBinder, grouped);
        ArrayList<Boolean> nullable = new ArrayList<Boolean>();
        for (AggregationMetadata.ParameterMetadata metadata : parameterMetadatas) {
            if (metadata.getParameterType() == AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL) {
                nullable.add(false);
                continue;
            }
            if (metadata.getParameterType() != AggregationMetadata.ParameterMetadata.ParameterType.NULLABLE_INPUT_CHANNEL) continue;
            nullable.add(true);
        }
        Preconditions.checkState((nullable.size() == parameterVariables.size() ? 1 : 0) != 0, (Object)"Number of parameters does not match");
        for (int i = 0; i < parameterVariables.size(); ++i) {
            if (((Boolean)nullable.get(i)).booleanValue()) continue;
            IfStatement.IfStatementBuilder builder = IfStatement.ifStatementBuilder(context);
            Variable variableDefinition = parameterVariables.get(i);
            builder.comment("if(!%s.isNull(position))", variableDefinition.getName()).condition(new com.facebook.presto.byteCode.Block(context).getVariable(variableDefinition).getVariable(positionVariable).invokeInterface(Block.class, "isNull", Boolean.TYPE, Integer.TYPE)).ifTrue(OpCode.NOP).ifFalse(loopBody);
            loopBody = new com.facebook.presto.byteCode.Block(context).append(builder.build());
        }
        if (sampleWeightVariable != null) {
            loopBody = AccumulatorCompiler.generateComputeSampleWeightAndCheckGreaterThanZero(context, loopBody, sampleWeightVariable, masksBlock, sampleWeightsBlock, positionVariable);
        } else {
            IfStatement.IfStatementBuilder builder = IfStatement.ifStatementBuilder(context);
            builder.comment("if(testMask(%s, position))", masksBlock.getName()).condition(new com.facebook.presto.byteCode.Block(context).getVariable(masksBlock).getVariable(positionVariable).invokeStatic(CompilerOperations.class, "testMask", Boolean.TYPE, Block.class, Integer.TYPE)).ifTrue(loopBody).ifFalse(OpCode.NOP);
            loopBody = new com.facebook.presto.byteCode.Block(context).append(builder.build());
        }
        block.append(new ForLoop.ForLoopBuilder(context).initialize(new com.facebook.presto.byteCode.Block(context).putVariable(positionVariable, 0)).condition(new com.facebook.presto.byteCode.Block(context).getVariable(positionVariable).getVariable(rowsVariable).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, Integer.TYPE, Integer.TYPE)).update(new com.facebook.presto.byteCode.Block(context).incrementVariable(positionVariable, (byte)1)).body(loopBody).build());
        return block;
    }

    private static com.facebook.presto.byteCode.Block generateComputeSampleWeightAndCheckGreaterThanZero(CompilerContext context, com.facebook.presto.byteCode.Block body, Variable sampleWeight, Variable masks, Variable sampleWeights, Variable position) {
        com.facebook.presto.byteCode.Block block = new com.facebook.presto.byteCode.Block(context).comment("sampleWeight = computeSampleWeight(masks, sampleWeights, position);").getVariable(masks).getVariable(sampleWeights).getVariable(position).invokeStatic(ApproximateUtils.class, "computeSampleWeight", Long.TYPE, Block.class, Block.class, Integer.TYPE).putVariable(sampleWeight);
        IfStatement.IfStatementBuilder builder = IfStatement.ifStatementBuilder(context);
        builder.comment("if(sampleWeight > 0)", new Object[0]).condition(new com.facebook.presto.byteCode.Block(context).getVariable(sampleWeight).invokeStatic(CompilerOperations.class, "longGreaterThanZero", Boolean.TYPE, Long.TYPE)).ifTrue(body).ifFalse(OpCode.NOP);
        return block.append(builder.build());
    }

    private static com.facebook.presto.byteCode.Block generateInvokeInputFunction(CompilerContext context, FieldDefinition stateField, Variable position, @Nullable Variable sampleWeight, List<Variable> parameterVariables, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, Method inputFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        com.facebook.presto.byteCode.Block block = new com.facebook.presto.byteCode.Block(context);
        if (grouped) {
            AccumulatorCompiler.generateSetGroupIdFromGroupIdsBlock(stateField, position, block);
        }
        block.comment("Call input function with unpacked Block arguments");
        Class<?>[] parameters = inputFunction.getParameterTypes();
        int inputChannel = 0;
        block7: for (int i = 0; i < parameters.length; ++i) {
            AggregationMetadata.ParameterMetadata parameterMetadata = parameterMetadatas.get(i);
            switch (parameterMetadata.getParameterType()) {
                case STATE: {
                    block.pushThis().getField(stateField);
                    continue block7;
                }
                case BLOCK_INDEX: {
                    block.getVariable(position);
                    continue block7;
                }
                case SAMPLE_WEIGHT: {
                    Preconditions.checkNotNull((Object)sampleWeight, (Object)"sampleWeight is null");
                    block.getVariable(sampleWeight);
                    continue block7;
                }
                case NULLABLE_INPUT_CHANNEL: {
                    block.getVariable(parameterVariables.get(inputChannel));
                    ++inputChannel;
                    continue block7;
                }
                case INPUT_CHANNEL: {
                    com.facebook.presto.byteCode.Block getBlockByteCode = new com.facebook.presto.byteCode.Block(context).getVariable(parameterVariables.get(inputChannel));
                    AccumulatorCompiler.pushStackType(block, parameterMetadata.getSqlType(), getBlockByteCode, parameters[i], callSiteBinder);
                    ++inputChannel;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter type: " + (Object)((Object)parameterMetadata.getParameterType()));
                }
            }
        }
        block.invokeStatic(inputFunction);
        return block;
    }

    private static void pushStackType(com.facebook.presto.byteCode.Block block, Type sqlType, com.facebook.presto.byteCode.Block getBlockByteCode, Class<?> parameter, CallSiteBinder callSiteBinder) {
        if (parameter == Block.class) {
            block.append(getBlockByteCode);
        } else if (parameter == Long.TYPE) {
            block.comment("%s.getLong(block, position)", sqlType.getName()).append(SqlTypeByteCodeExpression.constantType(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), callSiteBinder, sqlType)).append(getBlockByteCode).getVariable("position").invokeInterface(Type.class, "getLong", Long.TYPE, Block.class, Integer.TYPE);
        } else if (parameter == Double.TYPE) {
            block.comment("%s.getDouble(block, position)", sqlType.getName()).append(SqlTypeByteCodeExpression.constantType(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), callSiteBinder, sqlType)).append(getBlockByteCode).getVariable("position").invokeInterface(Type.class, "getDouble", Double.TYPE, Block.class, Integer.TYPE);
        } else if (parameter == Boolean.TYPE) {
            block.comment("%s.getBoolean(block, position)", sqlType.getName()).append(SqlTypeByteCodeExpression.constantType(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), callSiteBinder, sqlType)).append(getBlockByteCode).getVariable("position").invokeInterface(Type.class, "getBoolean", Boolean.TYPE, Block.class, Integer.TYPE);
        } else if (parameter == Slice.class) {
            block.comment("%s.getBoolean(block, position)", sqlType.getName()).append(SqlTypeByteCodeExpression.constantType(new CompilerContext(Bootstrap.BOOTSTRAP_METHOD), callSiteBinder, sqlType)).append(getBlockByteCode).getVariable("position").invokeInterface(Type.class, "getSlice", Slice.class, Block.class, Integer.TYPE);
        } else {
            throw new IllegalArgumentException("Unsupported parameter type: " + parameter.getSimpleName());
        }
    }

    private static void generateAddIntermediateAsCombine(ClassDefinition definition, FieldDefinition stateField, FieldDefinition stateSerializerField, FieldDefinition stateFactoryField, Method combineFunction, Class<?> singleStateClass, boolean grouped) {
        CompilerContext context = new CompilerContext();
        com.facebook.presto.byteCode.Block body = AccumulatorCompiler.declareAddIntermediate(definition, grouped, context);
        Variable scratchStateVariable = context.declareVariable(singleStateClass, "scratchState");
        Variable positionVariable = context.declareVariable(Integer.TYPE, "position");
        body.comment("scratchState = stateFactory.createSingleState();").pushThis().getField(stateFactoryField).invokeInterface(AccumulatorStateFactory.class, "createSingleState", Object.class, new Class[0]).checkCast(scratchStateVariable.getType()).putVariable(scratchStateVariable);
        if (grouped) {
            AccumulatorCompiler.generateEnsureCapacity(stateField, body);
        }
        com.facebook.presto.byteCode.Block loopBody = new com.facebook.presto.byteCode.Block(context);
        if (grouped) {
            AccumulatorCompiler.generateSetGroupIdFromGroupIdsBlock(stateField, positionVariable, loopBody);
        }
        loopBody.comment("stateSerializer.deserialize(block, position, scratchState)").pushThis().getField(stateSerializerField).getVariable("block").getVariable(positionVariable).getVariable(scratchStateVariable).invokeInterface(AccumulatorStateSerializer.class, "deserialize", Void.TYPE, Block.class, Integer.TYPE, Object.class);
        loopBody.comment("combine(state, scratchState)").pushThis().getField(stateField).getVariable("scratchState").invokeStatic(combineFunction);
        body.append(AccumulatorCompiler.generateBlockNonNullPositionForLoop(context, positionVariable, loopBody)).ret();
    }

    private static void generateSetGroupIdFromGroupIdsBlock(FieldDefinition stateField, Variable positionVariable, com.facebook.presto.byteCode.Block block) {
        block.comment("state.setGroupId(groupIdsBlock.getGroupId(position))").pushThis().getField(stateField).getVariable("groupIdsBlock").getVariable(positionVariable).invokeVirtual(GroupByIdBlock.class, "getGroupId", Long.TYPE, Integer.TYPE).invokeVirtual(stateField.getType(), "setGroupId", ParameterizedType.type(Void.TYPE), ParameterizedType.type(Long.TYPE));
    }

    private static void generateEnsureCapacity(FieldDefinition stateField, com.facebook.presto.byteCode.Block block) {
        block.comment("state.ensureCapacity(groupIdsBlock.getGroupCount())").pushThis().getField(stateField).getVariable("groupIdsBlock").invokeVirtual(GroupByIdBlock.class, "getGroupCount", Long.TYPE, new Class[0]).invokeVirtual(stateField.getType(), "ensureCapacity", ParameterizedType.type(Void.TYPE), ParameterizedType.type(Long.TYPE));
    }

    private static com.facebook.presto.byteCode.Block declareAddIntermediate(ClassDefinition definition, boolean grouped, CompilerContext context) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        if (grouped) {
            parameters.add((Object)NamedParameterDefinition.arg("groupIdsBlock", GroupByIdBlock.class));
        }
        parameters.add((Object)NamedParameterDefinition.arg("block", Block.class));
        return definition.declareMethod(context, Access.a(Access.PUBLIC), "addIntermediate", ParameterizedType.type(Void.TYPE), (Iterable<NamedParameterDefinition>)parameters.build()).getBody();
    }

    private static void generateAddIntermediateAsIntermediateInput(ClassDefinition definition, FieldDefinition stateField, List<AggregationMetadata.ParameterMetadata> parameterMetadatas, Method intermediateInputFunction, CallSiteBinder callSiteBinder, boolean grouped) {
        CompilerContext context = new CompilerContext();
        com.facebook.presto.byteCode.Block body = AccumulatorCompiler.declareAddIntermediate(definition, grouped, context);
        if (grouped) {
            AccumulatorCompiler.generateEnsureCapacity(stateField, body);
        }
        Variable positionVariable = context.declareVariable(Integer.TYPE, "position");
        com.facebook.presto.byteCode.Block loopBody = AccumulatorCompiler.generateInvokeInputFunction(context, stateField, positionVariable, null, (List<Variable>)ImmutableList.of((Object)context.getVariable("block")), parameterMetadatas, intermediateInputFunction, callSiteBinder, grouped);
        body.append(AccumulatorCompiler.generateBlockNonNullPositionForLoop(context, positionVariable, loopBody)).ret();
    }

    private static com.facebook.presto.byteCode.Block generateBlockNonNullPositionForLoop(CompilerContext context, Variable positionVariable, com.facebook.presto.byteCode.Block loopBody) {
        Variable rowsVariable = context.declareVariable(Integer.TYPE, "rows");
        com.facebook.presto.byteCode.Block block = new com.facebook.presto.byteCode.Block(context).getVariable("block").invokeInterface(Block.class, "getPositionCount", Integer.TYPE, new Class[0]).putVariable(rowsVariable);
        IfStatement.IfStatementBuilder builder = IfStatement.ifStatementBuilder(context);
        builder.comment("if(!block.isNull(position))", new Object[0]).condition(new com.facebook.presto.byteCode.Block(context).getVariable("block").getVariable(positionVariable).invokeInterface(Block.class, "isNull", Boolean.TYPE, Integer.TYPE)).ifTrue(OpCode.NOP).ifFalse(loopBody);
        block.append(new ForLoop.ForLoopBuilder(context).initialize(new com.facebook.presto.byteCode.Block(context).putVariable(positionVariable, 0)).condition(new com.facebook.presto.byteCode.Block(context).getVariable(positionVariable).getVariable(rowsVariable).invokeStatic(CompilerOperations.class, "lessThan", Boolean.TYPE, Integer.TYPE, Integer.TYPE)).update(new com.facebook.presto.byteCode.Block(context).incrementVariable(positionVariable, (byte)1)).body(builder.build()).build());
        return block;
    }

    private static void generateGroupedEvaluateIntermediate(ClassDefinition definition, FieldDefinition stateSerializerField, FieldDefinition stateField) {
        definition.declareMethod(Access.a(Access.PUBLIC), "evaluateIntermediate", ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("groupId", Integer.TYPE), NamedParameterDefinition.arg("out", BlockBuilder.class)).getBody().comment("state.setGroupId(groupId)").pushThis().getField(stateField).getVariable("groupId").intToLong().invokeVirtual(stateField.getType(), "setGroupId", ParameterizedType.type(Void.TYPE), ParameterizedType.type(Long.TYPE)).comment("stateSerializer.serialize(state, out)").pushThis().getField(stateSerializerField).pushThis().getField(stateField).getVariable("out").invokeInterface(AccumulatorStateSerializer.class, "serialize", Void.TYPE, Object.class, BlockBuilder.class).ret();
    }

    private static void generateEvaluateIntermediate(ClassDefinition definition, MethodDefinition getIntermediateType, FieldDefinition stateSerializerField, FieldDefinition stateField) {
        CompilerContext context = new CompilerContext();
        com.facebook.presto.byteCode.Block body = definition.declareMethod(context, Access.a(Access.PUBLIC), "evaluateIntermediate", ParameterizedType.type(Block.class), new NamedParameterDefinition[0]).getBody();
        context.declareVariable(BlockBuilder.class, "out");
        body.comment("out = getIntermediateType().createBlockBuilder(new BlockBuilderStatus());").pushThis().invokeVirtual(getIntermediateType).newObject(BlockBuilderStatus.class).dup().invokeConstructor(BlockBuilderStatus.class, new Class[0]).invokeInterface(Type.class, "createBlockBuilder", BlockBuilder.class, BlockBuilderStatus.class).putVariable("out");
        body.comment("stateSerializer.serialize(state, out)").pushThis().getField(stateSerializerField).pushThis().getField(stateField).getVariable("out").invokeInterface(AccumulatorStateSerializer.class, "serialize", Void.TYPE, Object.class, BlockBuilder.class);
        body.comment("return out.build();").getVariable("out").invokeInterface(BlockBuilder.class, "build", Block.class, new Class[0]).retObject();
    }

    private static void generateGroupedEvaluateFinal(ClassDefinition definition, FieldDefinition confidenceField, FieldDefinition stateSerializerField, FieldDefinition stateField, @Nullable Method outputFunction, boolean approximate) {
        com.facebook.presto.byteCode.Block body = definition.declareMethod(Access.a(Access.PUBLIC), "evaluateFinal", ParameterizedType.type(Void.TYPE), NamedParameterDefinition.arg("groupId", Integer.TYPE), NamedParameterDefinition.arg("out", BlockBuilder.class)).getBody().comment("state.setGroupId(groupId)").pushThis().getField(stateField).getVariable("groupId").intToLong().invokeVirtual(stateField.getType(), "setGroupId", ParameterizedType.type(Void.TYPE), ParameterizedType.type(Long.TYPE));
        if (outputFunction != null) {
            body.comment("output(state, out)").pushThis().getField(stateField);
            if (approximate) {
                Preconditions.checkNotNull((Object)confidenceField, (Object)"confidenceField is null");
                body.pushThis().getField(confidenceField);
            }
            body.getVariable("out").invokeStatic(outputFunction);
        } else {
            Preconditions.checkArgument((!approximate ? 1 : 0) != 0, (Object)"Approximate aggregations must specify an output function");
            body.comment("stateSerializer.serialize(state, out)").pushThis().getField(stateSerializerField).pushThis().getField(stateField).getVariable("out").invokeInterface(AccumulatorStateSerializer.class, "serialize", Void.TYPE, Object.class, BlockBuilder.class);
        }
        body.ret();
    }

    private static void generateEvaluateFinal(ClassDefinition definition, MethodDefinition getFinalType, FieldDefinition confidenceField, FieldDefinition stateSerializerField, FieldDefinition stateField, @Nullable Method outputFunction, boolean approximate) {
        CompilerContext context = new CompilerContext();
        com.facebook.presto.byteCode.Block body = definition.declareMethod(context, Access.a(Access.PUBLIC), "evaluateFinal", ParameterizedType.type(Block.class), new NamedParameterDefinition[0]).getBody();
        context.declareVariable(BlockBuilder.class, "out");
        body.pushThis().invokeVirtual(getFinalType).newObject(BlockBuilderStatus.class).dup().invokeConstructor(BlockBuilderStatus.class, new Class[0]).invokeInterface(Type.class, "createBlockBuilder", BlockBuilder.class, BlockBuilderStatus.class).putVariable("out");
        if (outputFunction != null) {
            body.comment("output(state, out)").pushThis().getField(stateField);
            if (approximate) {
                Preconditions.checkNotNull((Object)confidenceField, (Object)"confidenceField is null");
                body.pushThis().getField(confidenceField);
            }
            body.getVariable("out").invokeStatic(outputFunction);
        } else {
            Preconditions.checkArgument((!approximate ? 1 : 0) != 0, (Object)"Approximate aggregations must specify an output function");
            body.comment("stateSerializer.serialize(state, out)").pushThis().getField(stateSerializerField).pushThis().getField(stateField).getVariable("out").invokeInterface(AccumulatorStateSerializer.class, "serialize", Void.TYPE, Object.class, BlockBuilder.class);
        }
        body.getVariable("out").invokeInterface(BlockBuilder.class, "build", Block.class, new Class[0]).retObject();
    }

    private static void generateConstructor(ClassDefinition definition, FieldDefinition stateSerializerField, FieldDefinition stateFactoryField, FieldDefinition inputChannelsField, FieldDefinition maskChannelField, @Nullable FieldDefinition sampleWeightChannelField, @Nullable FieldDefinition confidenceField, FieldDefinition stateField, boolean grouped) {
        com.facebook.presto.byteCode.Block body = definition.declareConstructor(Access.a(Access.PUBLIC), NamedParameterDefinition.arg("stateSerializer", AccumulatorStateSerializer.class), NamedParameterDefinition.arg("stateFactory", AccumulatorStateFactory.class), NamedParameterDefinition.arg("inputChannels", ParameterizedType.type(List.class, Integer.class)), NamedParameterDefinition.arg("maskChannel", ParameterizedType.type(Optional.class, Integer.class)), NamedParameterDefinition.arg("sampleWeightChannel", ParameterizedType.type(Optional.class, Integer.class)), NamedParameterDefinition.arg("confidence", Double.TYPE)).getBody().comment("super();").pushThis().invokeConstructor(Object.class, new Class[0]);
        AccumulatorCompiler.generateCastCheckNotNullAndAssign(body, stateSerializerField, "stateSerializer");
        AccumulatorCompiler.generateCastCheckNotNullAndAssign(body, stateFactoryField, "stateFactory");
        AccumulatorCompiler.generateCastCheckNotNullAndAssign(body, inputChannelsField, "inputChannels");
        AccumulatorCompiler.generateCastCheckNotNullAndAssign(body, maskChannelField, "maskChannel");
        if (sampleWeightChannelField != null) {
            AccumulatorCompiler.generateCastCheckNotNullAndAssign(body, sampleWeightChannelField, "sampleWeightChannel");
        }
        String createState = grouped ? "createGroupedState" : "createSingleState";
        if (confidenceField != null) {
            body.comment("this.confidence = confidence").pushThis().getVariable("confidence").putField(confidenceField);
        }
        body.comment("this.state = stateFactory.%s()", createState).pushThis().getVariable("stateFactory").invokeInterface(AccumulatorStateFactory.class, createState, Object.class, new Class[0]).checkCast(stateField.getType()).putField(stateField).ret();
    }

    private static void generateCastCheckNotNullAndAssign(com.facebook.presto.byteCode.Block block, FieldDefinition field, String variableName) {
        block.comment("this.%s = checkNotNull(%s, \"%s is null\"", field.getName(), variableName, variableName).pushThis().getVariable(variableName).checkCast(field.getType()).push(variableName + " is null").invokeStatic(Preconditions.class, "checkNotNull", Object.class, Object.class, Object.class).checkCast(field.getType()).putField(field);
    }
}

