/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.PipelineStats;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class TaskStats {
    private final DateTime createTime;
    private final DateTime firstStartTime;
    private final DateTime lastStartTime;
    private final DateTime endTime;
    private final Duration elapsedTime;
    private final Duration queuedTime;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int queuedPartitionedDrivers;
    private final int runningDrivers;
    private final int runningPartitionedDrivers;
    private final int completedDrivers;
    private final DataSize memoryReservation;
    private final Duration totalScheduledTime;
    private final Duration totalCpuTime;
    private final Duration totalUserTime;
    private final Duration totalBlockedTime;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final DataSize processedInputDataSize;
    private final long processedInputPositions;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final List<PipelineStats> pipelines;

    public TaskStats(DateTime createTime) {
        this(createTime, null, null, null, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), 0, 0, 0, 0, 0, 0, new DataSize(0.0, DataSize.Unit.BYTE), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new DataSize(0.0, DataSize.Unit.BYTE), 0L, new DataSize(0.0, DataSize.Unit.BYTE), 0L, new DataSize(0.0, DataSize.Unit.BYTE), 0L, (List<PipelineStats>)ImmutableList.of());
    }

    @JsonCreator
    public TaskStats(@JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="firstStartTime") DateTime firstStartTime, @JsonProperty(value="lastStartTime") DateTime lastStartTime, @JsonProperty(value="endTime") DateTime endTime, @JsonProperty(value="elapsedTime") Duration elapsedTime, @JsonProperty(value="queuedTime") Duration queuedTime, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="queuedPartitionedDrivers") int queuedPartitionedDrivers, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="runningPartitionedDrivers") int runningPartitionedDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="memoryReservation") DataSize memoryReservation, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="totalUserTime") Duration totalUserTime, @JsonProperty(value="totalBlockedTime") Duration totalBlockedTime, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="processedInputDataSize") DataSize processedInputDataSize, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="pipelines") List<PipelineStats> pipelines) {
        this.createTime = (DateTime)Preconditions.checkNotNull((Object)createTime, (Object)"createTime is null");
        this.firstStartTime = firstStartTime;
        this.lastStartTime = lastStartTime;
        this.endTime = endTime;
        this.elapsedTime = (Duration)Preconditions.checkNotNull((Object)elapsedTime, (Object)"elapsedTime is null");
        this.queuedTime = (Duration)Preconditions.checkNotNull((Object)queuedTime, (Object)"queuedTime is null");
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((queuedPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedPartitionedDrivers is negative");
        this.queuedPartitionedDrivers = queuedPartitionedDrivers;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((runningPartitionedDrivers >= 0 ? 1 : 0) != 0, (Object)"runningPartitionedDrivers is negative");
        this.runningPartitionedDrivers = runningPartitionedDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        this.memoryReservation = (DataSize)Preconditions.checkNotNull((Object)memoryReservation, (Object)"memoryReservation is null");
        this.totalScheduledTime = (Duration)Preconditions.checkNotNull((Object)totalScheduledTime, (Object)"totalScheduledTime is null");
        this.totalCpuTime = (Duration)Preconditions.checkNotNull((Object)totalCpuTime, (Object)"totalCpuTime is null");
        this.totalUserTime = (Duration)Preconditions.checkNotNull((Object)totalUserTime, (Object)"totalUserTime is null");
        this.totalBlockedTime = (Duration)Preconditions.checkNotNull((Object)totalBlockedTime, (Object)"totalBlockedTime is null");
        this.rawInputDataSize = (DataSize)Preconditions.checkNotNull((Object)rawInputDataSize, (Object)"rawInputDataSize is null");
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.processedInputDataSize = (DataSize)Preconditions.checkNotNull((Object)processedInputDataSize, (Object)"processedInputDataSize is null");
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.outputDataSize = (DataSize)Preconditions.checkNotNull((Object)outputDataSize, (Object)"outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        this.pipelines = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(pipelines, (Object)"pipelines is null")));
    }

    @JsonProperty
    public DateTime getCreateTime() {
        return this.createTime;
    }

    @Nullable
    @JsonProperty
    public DateTime getFirstStartTime() {
        return this.firstStartTime;
    }

    @Nullable
    @JsonProperty
    public DateTime getLastStartTime() {
        return this.lastStartTime;
    }

    @Nullable
    @JsonProperty
    public DateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty
    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty
    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public DataSize getMemoryReservation() {
        return this.memoryReservation;
    }

    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    public Duration getTotalUserTime() {
        return this.totalUserTime;
    }

    @JsonProperty
    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public DataSize getProcessedInputDataSize() {
        return this.processedInputDataSize;
    }

    @JsonProperty
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public List<PipelineStats> getPipelines() {
        return this.pipelines;
    }

    @JsonProperty
    public int getQueuedPartitionedDrivers() {
        return this.queuedPartitionedDrivers;
    }

    @JsonProperty
    public int getRunningPartitionedDrivers() {
        return this.runningPartitionedDrivers;
    }

    public TaskStats summarize() {
        return new TaskStats(this.createTime, this.firstStartTime, this.lastStartTime, this.endTime, this.elapsedTime, this.queuedTime, this.totalDrivers, this.queuedDrivers, this.queuedPartitionedDrivers, this.runningDrivers, this.runningPartitionedDrivers, this.completedDrivers, this.memoryReservation, this.totalScheduledTime, this.totalCpuTime, this.totalUserTime, this.totalBlockedTime, this.rawInputDataSize, this.rawInputPositions, this.processedInputDataSize, this.processedInputPositions, this.outputDataSize, this.outputPositions, (List<PipelineStats>)ImmutableList.copyOf((Iterable)Iterables.transform(this.pipelines, PipelineStats.summarizePipelineStats())));
    }
}

