/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class SimplePagesHashStrategy
implements PagesHashStrategy {
    private final List<Type> types;
    private final List<List<Block>> channels;
    private final List<Integer> hashChannels;

    public SimplePagesHashStrategy(List<Type> types, List<List<Block>> channels, List<Integer> hashChannels) {
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.channels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(channels, (Object)"channels is null")));
        Preconditions.checkArgument((types.size() == channels.size() ? 1 : 0) != 0, (Object)"Expected types and channels to be the same length");
        this.hashChannels = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(hashChannels, (Object)"hashChannels is null")));
    }

    @Override
    public int getChannelCount() {
        return this.channels.size();
    }

    @Override
    public void appendTo(int blockIndex, int position, PageBuilder pageBuilder, int outputChannelOffset) {
        for (int i = 0; i < this.channels.size(); ++i) {
            Type type = this.types.get(i);
            List<Block> channel = this.channels.get(i);
            Block block = channel.get(blockIndex);
            type.appendTo(block, position, pageBuilder.getBlockBuilder(outputChannelOffset));
            ++outputChannelOffset;
        }
    }

    @Override
    public int hashPosition(int blockIndex, int position) {
        int result = 0;
        for (int hashChannel : this.hashChannels) {
            Type type = this.types.get(hashChannel);
            Block block = this.channels.get(hashChannel).get(blockIndex);
            result = result * 31 + TypeUtils.hashPosition(type, block, position);
        }
        return result;
    }

    @Override
    public int hashRow(int position, Block ... blocks) {
        int result = 0;
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            int hashChannel = this.hashChannels.get(i);
            Type type = this.types.get(hashChannel);
            Block block = blocks[i];
            result = result * 31 + TypeUtils.hashPosition(type, block, position);
        }
        return result;
    }

    @Override
    public boolean positionEqualsRow(int leftBlockIndex, int leftPosition, int rightPosition, Block ... rightBlocks) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block rightBlock;
            Block leftBlock;
            int hashChannel = this.hashChannels.get(i);
            Type type = this.types.get(hashChannel);
            if (TypeUtils.positionEqualsPosition(type, leftBlock = this.channels.get(hashChannel).get(leftBlockIndex), leftPosition, rightBlock = rightBlocks[i], rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionEqualsPosition(int leftBlockIndex, int leftPosition, int rightBlockIndex, int rightPosition) {
        for (int hashChannel : this.hashChannels) {
            Block rightBlock;
            List<Block> channel;
            Block leftBlock;
            Type type = this.types.get(hashChannel);
            if (TypeUtils.positionEqualsPosition(type, leftBlock = (channel = this.channels.get(hashChannel)).get(leftBlockIndex), leftPosition, rightBlock = channel.get(rightBlockIndex), rightPosition)) continue;
            return false;
        }
        return true;
    }
}

