/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.metadata.InsertTableHandle;
import com.facebook.presto.metadata.OutputTableHandle;
import com.facebook.presto.operator.RecordSinkProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.RecordSink;
import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RecordSinkManager
implements RecordSinkProvider {
    private final ConcurrentMap<String, ConnectorRecordSinkProvider> recordSinkProviders = new ConcurrentHashMap<String, ConnectorRecordSinkProvider>();

    public void addConnectorRecordSinkProvider(String connectorId, ConnectorRecordSinkProvider recordSinkProvider) {
        ConnectorRecordSinkProvider previous = this.recordSinkProviders.putIfAbsent(connectorId, recordSinkProvider);
        Preconditions.checkArgument((previous == null ? 1 : 0) != 0, (String)"Record sink provider already registered for connector '%s'", (Object[])new Object[]{connectorId});
    }

    @Override
    public RecordSink getRecordSink(OutputTableHandle tableHandle) {
        return this.providerFor(tableHandle.getConnectorId()).getRecordSink(tableHandle.getConnectorHandle());
    }

    @Override
    public RecordSink getRecordSink(InsertTableHandle tableHandle) {
        return this.providerFor(tableHandle.getConnectorId()).getRecordSink(tableHandle.getConnectorHandle());
    }

    private ConnectorRecordSinkProvider providerFor(String connectorId) {
        ConnectorRecordSinkProvider provider = (ConnectorRecordSinkProvider)this.recordSinkProviders.get(connectorId);
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (String)"No record sink provider for connector '%s'", (Object[])new Object[]{connectorId});
        return provider;
    }
}

