/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.Slice;
import java.io.Closeable;
import java.util.List;

public class RecordProjectOperator
implements Operator,
Closeable {
    private static final int ROWS_PER_REQUEST = 4096;
    private final OperatorContext operatorContext;
    private final RecordCursor cursor;
    private final List<Type> types;
    private final PageBuilder pageBuilder;
    private boolean finishing;
    private long completedBytes;
    private long readTimeNanos;

    public RecordProjectOperator(OperatorContext operatorContext, RecordSet recordSet) {
        this(operatorContext, recordSet.getColumnTypes(), recordSet.cursor());
    }

    public RecordProjectOperator(OperatorContext operatorContext, List<Type> columnTypes, RecordCursor cursor) {
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.cursor = (RecordCursor)Preconditions.checkNotNull((Object)cursor, (Object)"cursor is null");
        ImmutableList.Builder types = ImmutableList.builder();
        for (Type columnType : columnTypes) {
            types.add((Object)columnType);
        }
        this.types = types.build();
        this.pageBuilder = new PageBuilder(this.getTypes());
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public RecordCursor getCursor() {
        return this.cursor;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.close();
    }

    @Override
    public void close() {
        this.finishing = true;
        this.cursor.close();
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.pageBuilder.isEmpty();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return NOT_BLOCKED;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " can not take input");
    }

    @Override
    public Page getOutput() {
        if (!this.finishing) {
            int i;
            for (i = 0; i < 4096 && !this.pageBuilder.isFull(); ++i) {
                if (!this.cursor.advanceNextPosition()) {
                    this.finishing = true;
                    break;
                }
                this.pageBuilder.declarePosition();
                for (int column = 0; column < this.types.size(); ++column) {
                    BlockBuilder output = this.pageBuilder.getBlockBuilder(column);
                    if (this.cursor.isNull(column)) {
                        output.appendNull();
                        continue;
                    }
                    Type type = this.getTypes().get(column);
                    Class javaType = type.getJavaType();
                    if (javaType == Boolean.TYPE) {
                        type.writeBoolean(output, this.cursor.getBoolean(column));
                        continue;
                    }
                    if (javaType == Long.TYPE) {
                        type.writeLong(output, this.cursor.getLong(column));
                        continue;
                    }
                    if (javaType == Double.TYPE) {
                        type.writeDouble(output, this.cursor.getDouble(column));
                        continue;
                    }
                    if (javaType == Slice.class) {
                        Slice slice = this.cursor.getSlice(column);
                        type.writeSlice(output, slice, 0, slice.length());
                        continue;
                    }
                    throw new AssertionError((Object)("Unimplemented type: " + javaType.getName()));
                }
            }
            long endCompletedBytes = this.cursor.getCompletedBytes();
            long endReadTimeNanos = this.cursor.getReadTimeNanos();
            this.operatorContext.recordGeneratedInput(endCompletedBytes - this.completedBytes, i, endReadTimeNanos - this.readTimeNanos);
            this.completedBytes = endCompletedBytes;
            this.readTimeNanos = endReadTimeNanos;
        }
        if (this.pageBuilder.isEmpty() || !this.finishing && !this.pageBuilder.isFull()) {
            return null;
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }
}

