/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;

public final class ProjectionFunctions {
    private ProjectionFunctions() {
    }

    public static ProjectionFunction singleColumn(Type columnType, int channelIndex) {
        return new SingleColumnProjection(columnType, channelIndex);
    }

    private static class SingleColumnProjection
    implements ProjectionFunction {
        private final Type columnType;
        private final int channelIndex;

        public SingleColumnProjection(Type columnType, int channelIndex) {
            Preconditions.checkNotNull((Object)columnType, (Object)"columnType is null");
            Preconditions.checkArgument((channelIndex >= 0 ? 1 : 0) != 0, (Object)"channelIndex is negative");
            this.columnType = columnType;
            this.channelIndex = channelIndex;
        }

        @Override
        public Type getType() {
            return this.columnType;
        }

        @Override
        public void project(int position, Block[] blocks, BlockBuilder output) {
            if (blocks[this.channelIndex].isNull(position)) {
                output.appendNull();
            } else {
                this.columnType.appendTo(blocks[this.channelIndex], position, output);
            }
        }

        @Override
        public void project(RecordCursor cursor, BlockBuilder output) {
            if (cursor.isNull(this.channelIndex)) {
                output.appendNull();
            } else {
                Class javaType = this.columnType.getJavaType();
                if (javaType == Boolean.TYPE) {
                    this.columnType.writeBoolean(output, cursor.getBoolean(this.channelIndex));
                } else if (javaType == Long.TYPE) {
                    this.columnType.writeLong(output, cursor.getLong(this.channelIndex));
                } else if (javaType == Double.TYPE) {
                    this.columnType.writeDouble(output, cursor.getDouble(this.channelIndex));
                } else if (javaType == Slice.class) {
                    Slice slice = cursor.getSlice(this.channelIndex);
                    this.columnType.writeSlice(output, slice, 0, slice.length());
                } else {
                    throw new UnsupportedOperationException("not yet implemented: " + javaType);
                }
            }
        }
    }
}

