/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PagesIndexComparator;
import com.google.common.base.Preconditions;

public class PagesIndexOrdering {
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;
    private final PagesIndexComparator comparator;

    public PagesIndexOrdering(PagesIndexComparator comparator) {
        this.comparator = (PagesIndexComparator)Preconditions.checkNotNull((Object)comparator, (Object)"comparator is null");
    }

    public PagesIndexComparator getComparator() {
        return this.comparator;
    }

    public void sort(PagesIndex pagesIndex) {
        this.quickSort(pagesIndex, 0, pagesIndex.getPositionCount());
    }

    private void quickSort(PagesIndex pagesIndex, int from, int to) {
        int c;
        int a;
        int len = to - from;
        if (len < 7) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && this.comparator.compareTo(pagesIndex, j - 1, j) > 0; --j) {
                    pagesIndex.swap(j, j - 1);
                }
            }
            return;
        }
        int m = from + len / 2;
        if (len > 7) {
            int l = from;
            int n = to - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.median3(pagesIndex, l, l + s, l + 2 * s);
                m = this.median3(pagesIndex, m - s, m, m + s);
                n = this.median3(pagesIndex, n - 2 * s, n - s, n);
            }
            m = this.median3(pagesIndex, l, m, n);
        }
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = this.comparator.compareTo(pagesIndex, b, m)) <= 0) {
                if (comparison == 0) {
                    if (a == m) {
                        m = b;
                    } else if (b == m) {
                        m = a;
                    }
                    pagesIndex.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = this.comparator.compareTo(pagesIndex, c, m)) >= 0) {
                if (comparison == 0) {
                    if (c == m) {
                        m = d;
                    } else if (d == m) {
                        m = c;
                    }
                    pagesIndex.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            if (b == m) {
                m = d;
            } else if (c == m) {
                m = c;
            }
            pagesIndex.swap(b++, c--);
        }
        int n = to;
        int s = Math.min(a - from, b - a);
        this.vectorSwap(pagesIndex, from, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vectorSwap(pagesIndex, b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.quickSort(pagesIndex, from, from + s);
        }
        if ((s = d - c) > 1) {
            this.quickSort(pagesIndex, n - s, n);
        }
    }

    private int median3(PagesIndex pagesIndex, int a, int b, int c) {
        int ab = this.comparator.compareTo(pagesIndex, a, b);
        int ac = this.comparator.compareTo(pagesIndex, a, c);
        int bc = this.comparator.compareTo(pagesIndex, b, c);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private void vectorSwap(PagesIndex pagesIndex, int from, int l, int s) {
        int i = 0;
        while (i < s) {
            pagesIndex.swap(from, l);
            ++i;
            ++from;
            ++l;
        }
    }
}

