/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.InMemoryJoinHash;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.PagesIndexComparator;
import com.facebook.presto.operator.SimplePagesHashStrategy;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;

public class PagesIndex
implements Swapper {
    private static final Logger log = Logger.get(PagesIndex.class);
    private static final OrderingCompiler orderingCompiler = new OrderingCompiler();
    private static final JoinCompiler joinCompiler = new JoinCompiler();
    private final List<Type> types;
    private final OperatorContext operatorContext;
    private final LongArrayList valueAddresses;
    private final ObjectArrayList<Block>[] channels;
    private int positionCount;
    private long pagesMemorySize;
    private long estimatedSize;

    public PagesIndex(List<Type> types, int expectedPositions, OperatorContext operatorContext) {
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
        this.operatorContext = (OperatorContext)Preconditions.checkNotNull((Object)operatorContext, (Object)"operatorContext is null");
        this.valueAddresses = new LongArrayList(expectedPositions);
        this.channels = new ObjectArrayList[types.size()];
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = ObjectArrayList.wrap((Object[])new Block[1024], (int)0);
        }
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public LongArrayList getValueAddresses() {
        return this.valueAddresses;
    }

    public ObjectArrayList<Block> getChannel(int channel) {
        return this.channels[channel];
    }

    public void addPage(Page page) {
        this.positionCount += page.getPositionCount();
        int pageIndex = this.channels[0].size();
        for (int i = 0; i < this.channels.length; ++i) {
            Block block = page.getBlock(i);
            this.channels[i].add((Object)block);
            this.pagesMemorySize += (long)block.getSizeInBytes();
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            long sliceAddress = SyntheticAddress.encodeSyntheticAddress(pageIndex, position);
            this.valueAddresses.add(sliceAddress);
        }
        this.estimatedSize = this.operatorContext.setMemoryReservation(this.calculateEstimatedSize());
    }

    public DataSize getEstimatedSize() {
        return new DataSize((double)this.estimatedSize, DataSize.Unit.BYTE);
    }

    private long calculateEstimatedSize() {
        long channelsArraySize = SizeOf.sizeOf((Object[])this.channels[0].elements()) * (long)this.channels.length;
        long addressesArraySize = SizeOf.sizeOf((long[])this.valueAddresses.elements());
        return this.pagesMemorySize + channelsArraySize + addressesArraySize;
    }

    public Type getType(int channel) {
        return this.types.get(channel);
    }

    public void swap(int a, int b) {
        long[] elements = this.valueAddresses.elements();
        long temp = elements[a];
        elements[a] = elements[b];
        elements[b] = temp;
    }

    public int buildPage(int position, int[] outputChannels, PageBuilder pageBuilder) {
        while (!pageBuilder.isFull() && position < this.positionCount) {
            long pageAddress = this.valueAddresses.getLong(position);
            int blockIndex = SyntheticAddress.decodeSliceIndex(pageAddress);
            int blockPosition = SyntheticAddress.decodePosition(pageAddress);
            for (int i = 0; i < outputChannels.length; ++i) {
                int outputChannel = outputChannels[i];
                Type type = this.types.get(outputChannel);
                Block block = (Block)this.channels[outputChannel].get(blockIndex);
                type.appendTo(block, blockPosition, pageBuilder.getBlockBuilder(i));
            }
            ++position;
        }
        return position;
    }

    public void appendTo(int channel, int position, BlockBuilder output) {
        long pageAddress = this.valueAddresses.getLong(position);
        Type type = this.types.get(channel);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        type.appendTo(block, blockPosition, output);
    }

    public boolean isNull(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return block.isNull(blockPosition);
    }

    public boolean getBoolean(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getBoolean(block, blockPosition);
    }

    public long getLong(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getLong(block, blockPosition);
    }

    public double getDouble(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getDouble(block, blockPosition);
    }

    public Slice getSlice(int channel, int position) {
        long pageAddress = this.valueAddresses.getLong(position);
        Block block = (Block)this.channels[channel].get(SyntheticAddress.decodeSliceIndex(pageAddress));
        int blockPosition = SyntheticAddress.decodePosition(pageAddress);
        return this.types.get(channel).getSlice(block, blockPosition);
    }

    public void sort(List<Type> sortTypes, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        orderingCompiler.compilePagesIndexOrdering(sortTypes, sortChannels, sortOrders).sort(this);
    }

    public IntComparator createComparator(final List<Type> sortTypes, final List<Integer> sortChannels, final List<SortOrder> sortOrders) {
        return new AbstractIntComparator(){
            private final PagesIndexComparator comparator;
            {
                this.comparator = orderingCompiler.compilePagesIndexOrdering(sortTypes, sortChannels, sortOrders).getComparator();
            }

            public int compare(int leftPosition, int rightPosition) {
                return this.comparator.compareTo(PagesIndex.this, leftPosition, rightPosition);
            }
        };
    }

    public LookupSource createLookupSource(List<Integer> joinChannels) {
        try {
            JoinCompiler.LookupSourceFactory lookupSourceFactory = joinCompiler.compileLookupSourceFactory(this.types, joinChannels);
            ImmutableList.Builder joinChannelTypes = ImmutableList.builder();
            for (Integer joinChannel : joinChannels) {
                joinChannelTypes.add((Object)this.types.get(joinChannel));
            }
            LookupSource lookupSource = lookupSourceFactory.createLookupSource(this.valueAddresses, (List<Type>)joinChannelTypes.build(), (List<List<Block>>)ImmutableList.copyOf((Object[])this.channels), this.operatorContext);
            return lookupSource;
        }
        catch (Exception e) {
            log.error((Throwable)e, "Lookup source compile failed for types=%s error=%s", new Object[]{this.types, e});
            SimplePagesHashStrategy hashStrategy = new SimplePagesHashStrategy(this.types, (List<List<Block>>)ImmutableList.copyOf((Object[])this.channels), joinChannels);
            ImmutableList.Builder hashTypes = ImmutableList.builder();
            for (Integer channel : joinChannels) {
                hashTypes.add((Object)this.types.get(channel));
            }
            return new InMemoryJoinHash(this.valueAddresses, (List<Type>)hashTypes.build(), hashStrategy, this.operatorContext);
        }
    }
}

