/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.OperatorContext;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;

public class MemoryManager {
    private final OperatorContext operatorContext;
    private long currentMemoryReservation;

    public MemoryManager(OperatorContext operatorContext) {
        this.operatorContext = operatorContext;
    }

    public boolean canUse(long memorySize) {
        long delta = (memorySize -= this.operatorContext.getOperatorPreAllocatedMemory().toBytes()) - this.currentMemoryReservation;
        if (delta <= 0L) {
            return true;
        }
        if (!this.operatorContext.reserveMemory(delta)) {
            return false;
        }
        this.currentMemoryReservation = Math.max(this.currentMemoryReservation, memorySize);
        return true;
    }

    public void freeMemory(long bytes) {
        Preconditions.checkState((this.currentMemoryReservation - bytes >= 0L ? 1 : 0) != 0);
        this.operatorContext.freeMemory(bytes);
        this.currentMemoryReservation -= bytes;
    }

    public boolean isFull() {
        return this.currentMemoryReservation >= this.operatorContext.getMaxMemorySize().toBytes();
    }

    public boolean canUseDelta(long deltaBytes) {
        long requestedMemoryBytes = deltaBytes + this.currentMemoryReservation;
        return this.canUse(requestedMemoryBytes);
    }

    public DataSize getMaxMemorySize() {
        return this.operatorContext.getMaxMemorySize();
    }
}

