/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.PrestoMediaTypes;
import com.facebook.presto.operator.PageBufferClientStatus;
import com.facebook.presto.operator.PageTooLargeException;
import com.facebook.presto.operator.PageTransportErrorException;
import com.facebook.presto.operator.PageTransportTimeoutException;
import com.facebook.presto.serde.PagesSerde;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.ResponseHandlerUtils;
import io.airlift.http.client.ResponseTooLargeException;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.log.Logger;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.SliceInput;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public final class HttpPageBufferClient
implements Closeable {
    private static final int INITIAL_DELAY_MILLIS = 1;
    private static final int MAX_DELAY_MILLIS = 100;
    private static final Logger log = Logger.get(HttpPageBufferClient.class);
    private final HttpClient httpClient;
    private final DataSize maxResponseSize;
    private final Duration minErrorDuration;
    private final URI location;
    private final ClientCallback clientCallback;
    private final BlockEncodingSerde blockEncodingSerde;
    private final ScheduledExecutorService executor;
    @GuardedBy(value="this")
    private final Stopwatch errorStopwatch;
    @GuardedBy(value="this")
    private boolean closed;
    @GuardedBy(value="this")
    private HttpClient.HttpResponseFuture<PagesResponse> future;
    @GuardedBy(value="this")
    private DateTime lastUpdate = DateTime.now();
    @GuardedBy(value="this")
    private long token;
    @GuardedBy(value="this")
    private boolean scheduled;
    @GuardedBy(value="this")
    private long errorDelayMillis;
    private final AtomicInteger pagesReceived = new AtomicInteger();
    private final AtomicInteger requestsScheduled = new AtomicInteger();
    private final AtomicInteger requestsCompleted = new AtomicInteger();
    private final AtomicInteger requestsFailed = new AtomicInteger();

    public HttpPageBufferClient(HttpClient httpClient, DataSize maxResponseSize, Duration minErrorDuration, URI location, ClientCallback clientCallback, BlockEncodingSerde blockEncodingSerde, ScheduledExecutorService executor) {
        this(httpClient, maxResponseSize, minErrorDuration, location, clientCallback, blockEncodingSerde, executor, Stopwatch.createUnstarted());
    }

    public HttpPageBufferClient(HttpClient httpClient, DataSize maxResponseSize, Duration minErrorDuration, URI location, ClientCallback clientCallback, BlockEncodingSerde blockEncodingSerde, ScheduledExecutorService executor, Stopwatch errorStopwatch) {
        this.httpClient = (HttpClient)Preconditions.checkNotNull((Object)httpClient, (Object)"httpClient is null");
        this.maxResponseSize = (DataSize)Preconditions.checkNotNull((Object)maxResponseSize, (Object)"maxResponseSize is null");
        this.minErrorDuration = (Duration)Preconditions.checkNotNull((Object)minErrorDuration, (Object)"minErrorDuration is null");
        this.location = (URI)Preconditions.checkNotNull((Object)location, (Object)"location is null");
        this.clientCallback = (ClientCallback)Preconditions.checkNotNull((Object)clientCallback, (Object)"clientCallback is null");
        this.blockEncodingSerde = (BlockEncodingSerde)Preconditions.checkNotNull((Object)blockEncodingSerde, (Object)"blockEncodingManager is null");
        this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        this.errorStopwatch = ((Stopwatch)Preconditions.checkNotNull((Object)errorStopwatch, (Object)"errorStopwatch is null")).reset();
    }

    public synchronized PageBufferClientStatus getStatus() {
        String state = this.closed ? "closed" : (this.future != null ? "running" : (this.scheduled ? "scheduled" : "queued"));
        String httpRequestState = "not scheduled";
        if (this.future != null) {
            httpRequestState = this.future.getState();
        }
        return new PageBufferClientStatus(this.location, state, this.lastUpdate, this.pagesReceived.get(), this.requestsScheduled.get(), this.requestsCompleted.get(), this.requestsFailed.get(), httpRequestState);
    }

    public synchronized boolean isRunning() {
        return this.future != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HttpClient.HttpResponseFuture<PagesResponse> future;
        boolean shouldSendDelete;
        HttpPageBufferClient httpPageBufferClient = this;
        synchronized (httpPageBufferClient) {
            shouldSendDelete = !this.closed;
            this.closed = true;
            future = this.future;
            this.future = null;
            this.lastUpdate = DateTime.now();
        }
        if (future != null) {
            future.cancel(true);
        }
        if (shouldSendDelete) {
            this.httpClient.executeAsync(Request.Builder.prepareDelete().setUri(this.location).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        }
    }

    public synchronized void scheduleRequest() {
        if (this.closed || this.future != null || this.scheduled) {
            return;
        }
        this.scheduled = true;
        this.errorStopwatch.start();
        this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    HttpPageBufferClient.this.initiateRequest();
                }
                catch (Throwable t) {
                    HttpPageBufferClient.this.clientCallback.clientFailed(HttpPageBufferClient.this, t);
                }
            }
        }, this.errorDelayMillis, TimeUnit.MILLISECONDS);
        this.lastUpdate = DateTime.now();
        this.requestsScheduled.incrementAndGet();
    }

    private synchronized void initiateRequest() {
        this.scheduled = false;
        if (this.closed || this.future != null) {
            return;
        }
        final URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.location).appendPath(String.valueOf(this.token)).build();
        this.future = this.httpClient.executeAsync(Request.Builder.prepareGet().setHeader("X-Presto-Max-Size", this.maxResponseSize.toString()).setUri(uri).build(), (ResponseHandler)new PageResponseHandler(this.blockEncodingSerde));
        Futures.addCallback(this.future, (FutureCallback)new FutureCallback<PagesResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(PagesResponse result) {
                Object pages;
                if (Thread.holdsLock(HttpPageBufferClient.this)) {
                    log.error("Can not handle callback while holding a lock on this");
                }
                HttpPageBufferClient.this.resetErrors();
                HttpPageBufferClient.this.requestsCompleted.incrementAndGet();
                HttpPageBufferClient httpPageBufferClient = HttpPageBufferClient.this;
                synchronized (httpPageBufferClient) {
                    if (result.getToken() == HttpPageBufferClient.this.token) {
                        pages = result.getPages();
                        HttpPageBufferClient.this.token = result.getNextToken();
                    } else {
                        pages = ImmutableList.of();
                    }
                }
                Iterator i$ = pages.iterator();
                while (i$.hasNext()) {
                    Page page = (Page)i$.next();
                    HttpPageBufferClient.this.pagesReceived.incrementAndGet();
                    HttpPageBufferClient.this.clientCallback.addPage(HttpPageBufferClient.this, page);
                }
                if (result.isClientClosed()) {
                    httpPageBufferClient = HttpPageBufferClient.this;
                    synchronized (httpPageBufferClient) {
                        HttpPageBufferClient.this.closed = true;
                        HttpPageBufferClient.this.future = null;
                        HttpPageBufferClient.this.lastUpdate = DateTime.now();
                    }
                    HttpPageBufferClient.this.clientCallback.clientFinished(HttpPageBufferClient.this);
                } else {
                    httpPageBufferClient = HttpPageBufferClient.this;
                    synchronized (httpPageBufferClient) {
                        HttpPageBufferClient.this.future = null;
                        HttpPageBufferClient.this.lastUpdate = DateTime.now();
                    }
                    HttpPageBufferClient.this.clientCallback.requestComplete(HttpPageBufferClient.this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Throwable t) {
                Duration errorDuration;
                log.debug("Request to %s failed %s", new Object[]{uri, t});
                if (Thread.holdsLock(HttpPageBufferClient.this)) {
                    log.error("Can not handle callback while holding a lock on this");
                }
                if ((t = HttpPageBufferClient.rewriteException(t)) instanceof PrestoException) {
                    HttpPageBufferClient.this.clientCallback.clientFailed(HttpPageBufferClient.this, t);
                }
                if ((errorDuration = HttpPageBufferClient.this.elapsedErrorDuration()).compareTo(HttpPageBufferClient.this.minErrorDuration) > 0) {
                    String message = String.format("Requests to %s failed for %s", uri, errorDuration);
                    HttpPageBufferClient.this.clientCallback.clientFailed(HttpPageBufferClient.this, (Throwable)((Object)new PageTransportTimeoutException(message, t)));
                }
                HttpPageBufferClient.this.increaseErrorDelay();
                HttpPageBufferClient.this.requestsFailed.incrementAndGet();
                HttpPageBufferClient.this.requestsCompleted.incrementAndGet();
                HttpPageBufferClient httpPageBufferClient = HttpPageBufferClient.this;
                synchronized (httpPageBufferClient) {
                    HttpPageBufferClient.this.future = null;
                    HttpPageBufferClient.this.lastUpdate = DateTime.now();
                }
                HttpPageBufferClient.this.clientCallback.requestComplete(HttpPageBufferClient.this);
            }
        }, (Executor)this.executor);
        this.lastUpdate = DateTime.now();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpPageBufferClient that = (HttpPageBufferClient)o;
        return this.location.equals(that.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String state;
        HttpPageBufferClient httpPageBufferClient = this;
        synchronized (httpPageBufferClient) {
            state = this.closed ? "CLOSED" : (this.future != null ? "RUNNING" : "QUEUED");
        }
        return Objects.toStringHelper((Object)this).add("location", (Object)this.location).addValue((Object)state).toString();
    }

    private static Throwable rewriteException(Throwable t) {
        if (t instanceof ResponseTooLargeException) {
            return new PageTooLargeException();
        }
        return t;
    }

    private synchronized Duration elapsedErrorDuration() {
        if (this.errorStopwatch.isRunning()) {
            this.errorStopwatch.stop();
        }
        long nanos = this.errorStopwatch.elapsed(TimeUnit.NANOSECONDS);
        return new Duration((double)nanos, TimeUnit.NANOSECONDS).convertTo(TimeUnit.MILLISECONDS);
    }

    private synchronized void increaseErrorDelay() {
        this.errorDelayMillis = this.errorDelayMillis == 0L ? 1L : Math.min(this.errorDelayMillis * 2L, 100L);
    }

    private synchronized void resetErrors() {
        this.errorStopwatch.reset();
    }

    public static class PagesResponse {
        private final long token;
        private final long nextToken;
        private final List<Page> pages;
        private final boolean clientClosed;

        public static PagesResponse createPagesResponse(long token, long nextToken, Iterable<Page> pages) {
            return new PagesResponse(token, nextToken, pages, false);
        }

        public static PagesResponse createEmptyPagesResponse(long token, long nextToken) {
            return new PagesResponse(token, nextToken, (Iterable<Page>)ImmutableList.of(), false);
        }

        public static PagesResponse createClosedResponse(long token) {
            return new PagesResponse(token, -1L, (Iterable<Page>)ImmutableList.of(), true);
        }

        private PagesResponse(long token, long nextToken, Iterable<Page> pages, boolean clientClosed) {
            this.token = token;
            this.nextToken = nextToken;
            this.pages = ImmutableList.copyOf(pages);
            this.clientClosed = clientClosed;
        }

        public long getToken() {
            return this.token;
        }

        public long getNextToken() {
            return this.nextToken;
        }

        public List<Page> getPages() {
            return this.pages;
        }

        public boolean isClientClosed() {
            return this.clientClosed;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("token", this.token).add("nextToken", this.nextToken).add("pagesSize", this.pages.size()).add("clientClosed", this.clientClosed).toString();
        }
    }

    public static class PageResponseHandler
    implements ResponseHandler<PagesResponse, RuntimeException> {
        private final BlockEncodingSerde blockEncodingSerde;

        public PageResponseHandler(BlockEncodingSerde blockEncodingSerde) {
            this.blockEncodingSerde = blockEncodingSerde;
        }

        public PagesResponse handleException(Request request, Exception exception) {
            throw ResponseHandlerUtils.propagate((Request)request, (Throwable)exception);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public PagesResponse handle(Request request, Response response) {
            if (response.getStatusCode() == HttpStatus.GONE.code()) {
                return PagesResponse.createClosedResponse(PageResponseHandler.getToken(response));
            }
            if (response.getStatusCode() == HttpStatus.NO_CONTENT.code()) {
                return PagesResponse.createEmptyPagesResponse(PageResponseHandler.getToken(response), PageResponseHandler.getNextToken(response));
            }
            if (response.getStatusCode() != HttpStatus.OK.code()) {
                throw new PageTransportErrorException(String.format("Expected response code to be 200, but was %s %s: %s", response.getStatusCode(), response.getStatusMessage(), request.getUri()));
            }
            String contentType = response.getHeader("Content-Type");
            if (contentType == null || !PageResponseHandler.mediaTypeMatches(contentType, PrestoMediaTypes.PRESTO_PAGES_TYPE)) {
                throw new PageTransportErrorException(String.format("Expected %s response from server but got %s: %s", PrestoMediaTypes.PRESTO_PAGES_TYPE, contentType, request.getUri()));
            }
            long token = PageResponseHandler.getToken(response);
            long nextToken = PageResponseHandler.getNextToken(response);
            try (InputStreamSliceInput input = new InputStreamSliceInput(response.getInputStream());){
                ImmutableList pages = ImmutableList.copyOf(PagesSerde.readPages(this.blockEncodingSerde, (SliceInput)input));
                PagesResponse pagesResponse = PagesResponse.createPagesResponse(token, nextToken, (Iterable<Page>)pages);
                return pagesResponse;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        private static long getToken(Response response) {
            String tokenHeader = response.getHeader("X-Presto-Page-Sequence-Id");
            if (tokenHeader == null) {
                throw new PageTransportErrorException(String.format("Expected %s header", "X-Presto-Page-Sequence-Id"));
            }
            return Long.parseLong(tokenHeader);
        }

        private static long getNextToken(Response response) {
            String nextTokenHeader = response.getHeader("X-Presto-Page-End-Sequence-Id");
            if (nextTokenHeader == null) {
                throw new PageTransportErrorException(String.format("Expected %s header", "X-Presto-Page-End-Sequence-Id"));
            }
            return Long.parseLong(nextTokenHeader);
        }

        private static boolean mediaTypeMatches(String value, MediaType range) {
            try {
                return MediaType.parse((String)value).is(range);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                return false;
            }
        }
    }

    public static interface ClientCallback {
        public void addPage(HttpPageBufferClient var1, Page var2);

        public void requestComplete(HttpPageBufferClient var1);

        public void clientFinished(HttpPageBufferClient var1);

        public void clientFailed(HttpPageBufferClient var1, Throwable var2);
    }
}

