/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.type.BigintType;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;

public class GroupByIdBlock
implements Block {
    private final long groupCount;
    private final Block block;

    public GroupByIdBlock(long groupCount, Block block) {
        Preconditions.checkNotNull((Object)block, (Object)"block is null");
        this.groupCount = groupCount;
        this.block = block;
    }

    public long getGroupCount() {
        return this.groupCount;
    }

    public long getGroupId(int position) {
        return BigintType.BIGINT.getLong(this.block, position);
    }

    public Block getRegion(int positionOffset, int length) {
        return this.block.getRegion(positionOffset, length);
    }

    public int getLength(int position) {
        return this.block.getLength(position);
    }

    public byte getByte(int position, int offset) {
        return this.block.getByte(position, offset);
    }

    public short getShort(int position, int offset) {
        return this.block.getShort(position, offset);
    }

    public int getInt(int position, int offset) {
        return this.block.getInt(position, offset);
    }

    public long getLong(int position, int offset) {
        return this.block.getLong(position, offset);
    }

    public float getFloat(int position, int offset) {
        return this.block.getFloat(position, offset);
    }

    public double getDouble(int position, int offset) {
        return this.block.getDouble(position, offset);
    }

    public Slice getSlice(int position, int offset, int length) {
        return this.block.getSlice(position, offset, length);
    }

    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        return this.block.bytesEqual(position, offset, otherSlice, otherOffset, length);
    }

    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        return this.block.bytesCompare(position, offset, length, otherSlice, otherOffset, otherLength);
    }

    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.block.writeBytesTo(position, offset, length, blockBuilder);
    }

    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        return this.block.equals(position, offset, otherBlock, otherPosition, otherOffset, length);
    }

    public int hash(int position, int offset, int length) {
        return this.block.hash(position, offset, length);
    }

    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        return this.block.compareTo(leftPosition, leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    public Block getSingleValueBlock(int position) {
        return this.block.getSingleValueBlock(position);
    }

    public boolean isNull(int position) {
        return this.block.isNull(position);
    }

    public int getPositionCount() {
        return this.block.getPositionCount();
    }

    public int getSizeInBytes() {
        return this.block.getSizeInBytes();
    }

    public BlockEncoding getEncoding() {
        return this.block.getEncoding();
    }

    public void assureLoaded() {
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("groupCount", this.groupCount).add("positionCount", this.getPositionCount()).toString();
    }
}

