/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class TypeParameter {
    private final String name;
    private final boolean comparableRequired;
    private final boolean orderableRequired;

    @JsonCreator
    public TypeParameter(@JsonProperty(value="name") String name, @JsonProperty(value="comparableRequired") boolean comparableRequired, @JsonProperty(value="orderableRequired") boolean orderableRequired) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.comparableRequired = comparableRequired;
        this.orderableRequired = orderableRequired;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public boolean isComparableRequired() {
        return this.comparableRequired;
    }

    @JsonProperty
    public boolean isOrderableRequired() {
        return this.orderableRequired;
    }

    public boolean canBind(Type type) {
        return !(this.comparableRequired && !type.isComparable() || this.orderableRequired && !type.isOrderable());
    }

    public String toString() {
        String value = this.name;
        if (this.comparableRequired) {
            value = value + ":comparable";
        }
        if (this.orderableRequired) {
            value = value + ":orderable";
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeParameter other = (TypeParameter)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.comparableRequired, other.comparableRequired) && Objects.equals(this.orderableRequired, other.orderableRequired);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.comparableRequired, this.orderableRequired);
    }
}

