/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import javax.annotation.concurrent.Immutable;

@Immutable
public class QualifiedTableName {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;

    @JsonCreator
    public static QualifiedTableName valueOf(String tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        ImmutableList ids = ImmutableList.copyOf((Iterable)Splitter.on((char)'.').split((CharSequence)tableName));
        Preconditions.checkArgument((ids.size() == 3 ? 1 : 0) != 0, (String)"Invalid tableName %s", (Object[])new Object[]{tableName});
        return new QualifiedTableName((String)ids.get(0), (String)ids.get(1), (String)ids.get(2));
    }

    public QualifiedTableName(String catalogName, String schemaName, String tableName) {
        MetadataUtil.checkTableName(catalogName, schemaName, tableName);
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public SchemaTableName asSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedTableName o = (QualifiedTableName)obj;
        return Objects.equal((Object)this.catalogName, (Object)o.catalogName) && Objects.equal((Object)this.schemaName, (Object)o.schemaName) && Objects.equal((Object)this.tableName, (Object)o.tableName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.catalogName, this.schemaName, this.tableName});
    }

    @JsonValue
    public String toString() {
        return this.catalogName + '.' + this.schemaName + '.' + this.tableName;
    }

    public static Function<SchemaTableName, QualifiedTableName> convertFromSchemaTableName(final String catalogName) {
        return new Function<SchemaTableName, QualifiedTableName>(){

            public QualifiedTableName apply(SchemaTableName input) {
                return new QualifiedTableName(catalogName, input.getSchemaName(), input.getTableName());
            }
        };
    }
}

