/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.List;

public enum OperatorType {
    ADD("+"){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    SUBTRACT("-"){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    MULTIPLY("*"){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    DIVIDE("/"){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    MODULUS("%"){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    NEGATION("-"){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 1);
        }
    }
    ,
    EQUAL("="){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateComparisonOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    NOT_EQUAL("<>"){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateComparisonOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    LESS_THAN("<"){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateComparisonOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    LESS_THAN_OR_EQUAL("<="){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateComparisonOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    GREATER_THAN(">"){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateComparisonOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    GREATER_THAN_OR_EQUAL(">="){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateComparisonOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
        }
    }
    ,
    BETWEEN("BETWEEN"){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateComparisonOperatorSignature((OperatorType)this, returnType, argumentTypes, 3);
        }
    }
    ,
    CAST("CAST"){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 1);
        }
    }
    ,
    SUBSCRIPT("[]"){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 2);
            Preconditions.checkArgument((argumentTypes.get(0).equals("array") || argumentTypes.get(0).equals("map") ? 1 : 0) != 0, (Object)"First argument must be an ARRAY or MAP");
            if (argumentTypes.get(0).equals("array")) {
                Preconditions.checkArgument((boolean)argumentTypes.get(1).equals("bigint"), (Object)"Second argument must be a BIGINT");
                String elementType = ((TypeSignature)TypeSignature.parseTypeSignature((String)argumentTypes.get(0)).getParameters().get(0)).toString();
                Preconditions.checkArgument((boolean)returnType.equals(elementType), (Object)"[] return type does not match ARRAY element type");
            } else {
                String valueType = ((TypeSignature)TypeSignature.parseTypeSignature((String)argumentTypes.get(0)).getParameters().get(1)).toString();
                Preconditions.checkArgument((boolean)returnType.equals(valueType), (Object)"[] return type does not match MAP value type");
            }
        }
    }
    ,
    HASH_CODE("HASH CODE"){

        @Override
        void validateSignature(String returnType, List<String> argumentTypes) {
            OperatorType.validateOperatorSignature((OperatorType)this, returnType, argumentTypes, 1);
            Preconditions.checkArgument((boolean)returnType.equals("bigint"), (String)"%s operator must return a BIGINT: %s", (Object[])new Object[]{this, OperatorType.formatSignature((OperatorType)this, returnType, argumentTypes)});
        }
    };

    private final String operator;

    private OperatorType(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    abstract void validateSignature(String var1, List<String> var2);

    private static void validateOperatorSignature(OperatorType operatorType, String returnType, List<String> argumentTypes, int expectedArgumentCount) {
        String signature = OperatorType.formatSignature(operatorType, returnType, argumentTypes);
        Preconditions.checkArgument((!returnType.equals("unknown") ? 1 : 0) != 0, (String)"%s operator return type can not be NULL: %s", (Object[])new Object[]{operatorType, signature});
        Preconditions.checkArgument((argumentTypes.size() == expectedArgumentCount ? 1 : 0) != 0, (String)"%s operator must have exactly %s argument: %s", (Object[])new Object[]{operatorType, expectedArgumentCount, signature});
    }

    private static void validateComparisonOperatorSignature(OperatorType operatorType, String returnType, List<String> argumentTypes, int expectedArgumentCount) {
        OperatorType.validateOperatorSignature(operatorType, returnType, argumentTypes, expectedArgumentCount);
        Preconditions.checkArgument((boolean)returnType.equals("boolean"), (String)"%s operator must return a BOOLEAN: %s", (Object[])new Object[]{operatorType, OperatorType.formatSignature(operatorType, returnType, argumentTypes)});
    }

    private static String formatSignature(OperatorType operatorType, String returnType, List<String> argumentTypes) {
        return (Object)((Object)operatorType) + "(" + Joiner.on((String)", ").join(argumentTypes) + ")::" + returnType;
    }
}

