/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.QualifiedTableName;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;

public final class MetadataUtil {
    private MetadataUtil() {
    }

    public static void checkTableName(String catalogName, Optional<String> schemaName, Optional<String> tableName) {
        MetadataUtil.checkCatalogName(catalogName);
        MetadataUtil.checkSchemaName(schemaName);
        MetadataUtil.checkTableName(tableName);
        Preconditions.checkArgument((schemaName.isPresent() || !tableName.isPresent() ? 1 : 0) != 0, (Object)"tableName specified but schemaName is missing");
    }

    public static String checkCatalogName(String catalogName) {
        return MetadataUtil.checkLowerCase(catalogName, "catalogName");
    }

    public static String checkSchemaName(String schemaName) {
        return MetadataUtil.checkLowerCase(schemaName, "schemaName");
    }

    public static Optional<String> checkSchemaName(Optional<String> schemaName) {
        return MetadataUtil.checkLowerCase(schemaName, "schemaName");
    }

    public static String checkTableName(String tableName) {
        return MetadataUtil.checkLowerCase(tableName, "tableName");
    }

    public static Optional<String> checkTableName(Optional<String> tableName) {
        return MetadataUtil.checkLowerCase(tableName, "tableName");
    }

    public static String checkColumnName(String catalogName) {
        return MetadataUtil.checkLowerCase(catalogName, "catalogName");
    }

    public static void checkTableName(String catalogName, String schemaName, String tableName) {
        MetadataUtil.checkLowerCase(catalogName, "catalogName");
        MetadataUtil.checkLowerCase(schemaName, "schemaName");
        MetadataUtil.checkLowerCase(tableName, "tableName");
    }

    public static Optional<String> checkLowerCase(Optional<String> value, String name) {
        if (value.isPresent()) {
            MetadataUtil.checkLowerCase((String)value.get(), name);
        }
        return value;
    }

    public static String checkLowerCase(String value, String name) {
        Preconditions.checkNotNull((Object)value, (String)"%s is null", (Object[])new Object[]{name});
        Preconditions.checkArgument((boolean)value.equals(value.toLowerCase(Locale.ENGLISH)), (String)"%s is not lowercase", (Object[])new Object[]{name});
        return value;
    }

    public static ColumnMetadata findColumnMetadata(ConnectorTableMetadata tableMetadata, String columnName) {
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            if (!columnName.equals(columnMetadata.getName())) continue;
            return columnMetadata;
        }
        return null;
    }

    public static Function<ColumnMetadata, Type> columnTypeGetter() {
        return new Function<ColumnMetadata, Type>(){

            public Type apply(ColumnMetadata columnMetadata) {
                return columnMetadata.getType();
            }
        };
    }

    public static Function<ColumnMetadata, String> columnNameGetter() {
        return new Function<ColumnMetadata, String>(){

            public String apply(ColumnMetadata columnMetadata) {
                return columnMetadata.getName();
            }
        };
    }

    public static QualifiedTableName createQualifiedTableName(Session session, QualifiedName name) {
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkArgument((name.getParts().size() <= 3 ? 1 : 0) != 0, (String)"Too many dots in table name: %s", (Object[])new Object[]{name});
        List parts = Lists.reverse((List)name.getParts());
        String tableName = (String)parts.get(0);
        String schemaName = parts.size() > 1 ? (String)parts.get(1) : session.getSchema();
        String catalogName = parts.size() > 2 ? (String)parts.get(2) : session.getCatalog();
        return new QualifiedTableName(catalogName, schemaName, tableName);
    }

    public static Function<SchemaTableName, String> schemaNameGetter() {
        return new Function<SchemaTableName, String>(){

            public String apply(SchemaTableName schemaTableName) {
                return schemaTableName.getSchemaName();
            }
        };
    }

    public static class TableMetadataBuilder {
        private final SchemaTableName tableName;
        private final ImmutableList.Builder<ColumnMetadata> columns = ImmutableList.builder();
        private int ordinalPosition;

        public static TableMetadataBuilder tableMetadataBuilder(String schemaName, String tableName) {
            return new TableMetadataBuilder(new SchemaTableName(schemaName, tableName));
        }

        public static TableMetadataBuilder tableMetadataBuilder(SchemaTableName tableName) {
            return new TableMetadataBuilder(tableName);
        }

        private TableMetadataBuilder(SchemaTableName tableName) {
            this.tableName = tableName;
        }

        public TableMetadataBuilder column(String columnName, Type type) {
            this.columns.add((Object)new ColumnMetadata(columnName, type, this.ordinalPosition, false));
            ++this.ordinalPosition;
            return this;
        }

        public TableMetadataBuilder partitionKeyColumn(String columnName, Type type) {
            this.columns.add((Object)new ColumnMetadata(columnName, type, this.ordinalPosition, true));
            ++this.ordinalPosition;
            return this;
        }

        public ConnectorTableMetadata build() {
            return new ConnectorTableMetadata(this.tableName, (List)this.columns.build());
        }
    }

    public static class SchemaMetadataBuilder {
        private final ImmutableMap.Builder<SchemaTableName, ConnectorTableMetadata> tables = ImmutableMap.builder();

        public static SchemaMetadataBuilder schemaMetadataBuilder() {
            return new SchemaMetadataBuilder();
        }

        public SchemaMetadataBuilder table(ConnectorTableMetadata tableMetadata) {
            this.tables.put((Object)tableMetadata.getTable(), (Object)tableMetadata);
            return this;
        }

        public ImmutableMap<SchemaTableName, ConnectorTableMetadata> build() {
            return this.tables.build();
        }
    }
}

