/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.ConfigurationAwareModule;
import io.airlift.configuration.ConfigurationFactory;

public class ConditionalModule
implements ConfigurationAwareModule {
    private final Module module;
    private final String property;
    private final String expectedValue;
    private ConfigurationFactory configurationFactory;

    public static ConfigurationAwareModule installIfPropertyEquals(Module module, String property, String expectedValue) {
        return new ConditionalModule(module, property, expectedValue);
    }

    private ConditionalModule(Module module, String property, String expectedValue) {
        this.module = (Module)Preconditions.checkNotNull((Object)module, (Object)"module is null");
        this.property = (String)Preconditions.checkNotNull((Object)property, (Object)"property is null");
        this.expectedValue = (String)Preconditions.checkNotNull((Object)expectedValue, (Object)"expectedValue is null");
    }

    public void setConfigurationFactory(ConfigurationFactory configurationFactory) {
        this.configurationFactory = (ConfigurationFactory)Preconditions.checkNotNull((Object)configurationFactory, (Object)"configurationFactory is null");
        configurationFactory.consumeProperty(this.property);
        if (!this.shouldInstall()) {
            configurationFactory.registerConfigurationClasses(this.module);
        }
    }

    public void configure(Binder binder) {
        Preconditions.checkState((this.configurationFactory != null ? 1 : 0) != 0, (Object)"configurationFactory was not set");
        if (!this.configurationFactory.getProperties().containsKey(this.property)) {
            binder.addError("Required configuration property '%s' was not set", new Object[]{this.property});
        }
        if (this.shouldInstall()) {
            binder.install(this.module);
        }
    }

    private boolean shouldInstall() {
        return this.expectedValue.equalsIgnoreCase((String)this.configurationFactory.getProperties().get(this.property));
    }
}

