/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.google.common.base.Preconditions;
import io.airlift.stats.CounterStat;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public final class SqlTaskIoStats {
    private final CounterStat inputDataSize;
    private final CounterStat inputPositions;
    private final CounterStat outputDataSize;
    private final CounterStat outputPositions;

    public SqlTaskIoStats() {
        this(new CounterStat(), new CounterStat(), new CounterStat(), new CounterStat());
    }

    public SqlTaskIoStats(CounterStat inputDataSize, CounterStat inputPositions, CounterStat outputDataSize, CounterStat outputPositions) {
        this.inputDataSize = (CounterStat)Preconditions.checkNotNull((Object)inputDataSize, (Object)"inputDataSize is null");
        this.inputPositions = (CounterStat)Preconditions.checkNotNull((Object)inputPositions, (Object)"inputPositions is null");
        this.outputDataSize = (CounterStat)Preconditions.checkNotNull((Object)outputDataSize, (Object)"outputDataSize is null");
        this.outputPositions = (CounterStat)Preconditions.checkNotNull((Object)outputPositions, (Object)"outputPositions is null");
    }

    @Managed
    @Nested
    public CounterStat getInputDataSize() {
        return this.inputDataSize;
    }

    @Managed
    @Nested
    public CounterStat getInputPositions() {
        return this.inputPositions;
    }

    @Managed
    @Nested
    public CounterStat getOutputDataSize() {
        return this.outputDataSize;
    }

    @Managed
    @Nested
    public CounterStat getOutputPositions() {
        return this.outputPositions;
    }

    public void merge(SqlTaskIoStats ioStats) {
        this.inputDataSize.merge(ioStats.inputDataSize);
        this.inputPositions.merge(ioStats.inputPositions);
        this.outputDataSize.merge(ioStats.outputDataSize);
        this.outputPositions.merge(ioStats.outputPositions);
    }

    public void resetTo(SqlTaskIoStats ioStats) {
        this.inputDataSize.resetTo(ioStats.inputDataSize);
        this.inputPositions.resetTo(ioStats.inputPositions);
        this.outputDataSize.resetTo(ioStats.outputDataSize);
        this.outputPositions.resetTo(ioStats.outputPositions);
    }
}

