/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import javax.validation.constraints.Min;

public class NodeSchedulerConfig {
    private int minCandidates = 10;
    private boolean locationAwareScheduling = true;
    private boolean includeCoordinator = true;
    private boolean multipleTasksPerNode;
    private int maxSplitsPerNode = 100;
    private int maxPendingSplitsPerNodePerTask = 10;

    public boolean isMultipleTasksPerNodeEnabled() {
        return this.multipleTasksPerNode;
    }

    @ConfigDescription(value="Allow nodes to be selected multiple times by the node scheduler, in a single stage")
    @Config(value="node-scheduler.multiple-tasks-per-node-enabled")
    public NodeSchedulerConfig setMultipleTasksPerNodeEnabled(boolean multipleTasksPerNode) {
        this.multipleTasksPerNode = multipleTasksPerNode;
        return this;
    }

    @Min(value=1L)
    public int getMinCandidates() {
        return this.minCandidates;
    }

    @Config(value="node-scheduler.min-candidates")
    public NodeSchedulerConfig setMinCandidates(int candidates) {
        this.minCandidates = candidates;
        return this;
    }

    public boolean isLocationAwareSchedulingEnabled() {
        return this.locationAwareScheduling;
    }

    @Config(value="node-scheduler.location-aware-scheduling-enabled")
    public NodeSchedulerConfig setLocationAwareSchedulingEnabled(boolean locationAwareScheduling) {
        this.locationAwareScheduling = locationAwareScheduling;
        return this;
    }

    public boolean isIncludeCoordinator() {
        return this.includeCoordinator;
    }

    @Config(value="node-scheduler.include-coordinator")
    public NodeSchedulerConfig setIncludeCoordinator(boolean includeCoordinator) {
        this.includeCoordinator = includeCoordinator;
        return this;
    }

    @Config(value="node-scheduler.max-pending-splits-per-node-per-task")
    public NodeSchedulerConfig setMaxPendingSplitsPerNodePerTask(int maxPendingSplitsPerNodePerTask) {
        this.maxPendingSplitsPerNodePerTask = maxPendingSplitsPerNodePerTask;
        return this;
    }

    public int getMaxPendingSplitsPerNodePerTask() {
        return this.maxPendingSplitsPerNodePerTask;
    }

    public int getMaxSplitsPerNode() {
        return this.maxSplitsPerNode;
    }

    @Config(value="node-scheduler.max-splits-per-node")
    public NodeSchedulerConfig setMaxSplitsPerNode(int maxSplitsPerNode) {
        this.maxSplitsPerNode = maxSplitsPerNode;
        return this;
    }
}

