/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.client.ErrorLocation;
import com.facebook.presto.client.FailureInfo;
import com.facebook.presto.execution.Failure;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.util.IterableTransformer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.validation.constraints.NotNull;

@Immutable
public class ExecutionFailureInfo {
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("(.*)\\.(.*)\\(([^:]*)(?::(.*))?\\)");
    private final String type;
    private final String message;
    private final ExecutionFailureInfo cause;
    private final List<ExecutionFailureInfo> suppressed;
    private final List<String> stack;
    private final ErrorLocation errorLocation;
    private final ErrorCode errorCode;

    @JsonCreator
    public ExecutionFailureInfo(@JsonProperty(value="type") String type, @JsonProperty(value="message") String message, @JsonProperty(value="cause") ExecutionFailureInfo cause, @JsonProperty(value="suppressed") List<ExecutionFailureInfo> suppressed, @JsonProperty(value="stack") List<String> stack, @JsonProperty(value="errorLocation") @Nullable ErrorLocation errorLocation, @JsonProperty(value="errorCode") @Nullable ErrorCode errorCode) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        Preconditions.checkNotNull(suppressed, (Object)"suppressed is null");
        Preconditions.checkNotNull(stack, (Object)"stack is null");
        this.type = type;
        this.message = message;
        this.cause = cause;
        this.suppressed = ImmutableList.copyOf(suppressed);
        this.stack = ImmutableList.copyOf(stack);
        this.errorLocation = errorLocation;
        this.errorCode = errorCode;
    }

    @NotNull
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Nullable
    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    @Nullable
    @JsonProperty
    public ExecutionFailureInfo getCause() {
        return this.cause;
    }

    @NotNull
    @JsonProperty
    public List<ExecutionFailureInfo> getSuppressed() {
        return this.suppressed;
    }

    @NotNull
    @JsonProperty
    public List<String> getStack() {
        return this.stack;
    }

    @Nullable
    @JsonProperty
    public ErrorLocation getErrorLocation() {
        return this.errorLocation;
    }

    @Nullable
    @JsonProperty
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public FailureInfo toFailureInfo() {
        List<FailureInfo> suppressed = IterableTransformer.on(this.suppressed).transform(new Function<ExecutionFailureInfo, FailureInfo>(){

            public FailureInfo apply(ExecutionFailureInfo input) {
                return input.toFailureInfo();
            }
        }).list();
        return new FailureInfo(this.type, this.message, this.cause == null ? null : this.cause.toFailureInfo(), suppressed, this.stack, this.errorLocation);
    }

    public RuntimeException toException() {
        return ExecutionFailureInfo.toException(this);
    }

    private static Failure toException(ExecutionFailureInfo executionFailureInfo) {
        if (executionFailureInfo == null) {
            return null;
        }
        Failure failure = new Failure(executionFailureInfo.getType(), executionFailureInfo.getMessage(), executionFailureInfo.getErrorCode(), ExecutionFailureInfo.toException(executionFailureInfo.getCause()));
        for (ExecutionFailureInfo suppressed : executionFailureInfo.getSuppressed()) {
            failure.addSuppressed(ExecutionFailureInfo.toException(suppressed));
        }
        ImmutableList.Builder stackTraceBuilder = ImmutableList.builder();
        for (String stack : executionFailureInfo.getStack()) {
            stackTraceBuilder.add((Object)ExecutionFailureInfo.toStackTraceElement(stack));
        }
        ImmutableList stackTrace = stackTraceBuilder.build();
        failure.setStackTrace((StackTraceElement[])stackTrace.toArray((Object[])new StackTraceElement[stackTrace.size()]));
        return failure;
    }

    public static StackTraceElement toStackTraceElement(String stack) {
        Matcher matcher = STACK_TRACE_PATTERN.matcher(stack);
        if (matcher.matches()) {
            String declaringClass = matcher.group(1);
            String methodName = matcher.group(2);
            String fileName = matcher.group(3);
            int number = -1;
            if (fileName.equals("Native Method")) {
                fileName = null;
                number = -2;
            } else if (matcher.group(4) != null) {
                number = Integer.parseInt(matcher.group(4));
            }
            return new StackTraceElement(declaringClass, methodName, fileName, number);
        }
        return new StackTraceElement("Unknown", stack, null, -1);
    }
}

