/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.SplitSource;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;

public class ConnectorAwareSplitSource
implements SplitSource {
    private final String connectorId;
    private final ConnectorSplitSource source;

    public ConnectorAwareSplitSource(String connectorId, ConnectorSplitSource source) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.source = (ConnectorSplitSource)Preconditions.checkNotNull((Object)source, (Object)"source is null");
    }

    @Override
    public String getDataSourceName() {
        return this.source.getDataSourceName();
    }

    @Override
    public List<Split> getNextBatch(int maxSize) throws InterruptedException {
        return Lists.transform((List)this.source.getNextBatch(maxSize), Split.fromConnectorSplit(this.connectorId));
    }

    @Override
    public void close() {
        this.source.close();
    }

    @Override
    public boolean isFinished() {
        return this.source.isFinished();
    }

    public String toString() {
        return this.connectorId + ":" + this.source;
    }
}

