/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class SystemColumnHandle
implements ConnectorColumnHandle {
    private final String columnName;

    @JsonCreator
    public SystemColumnHandle(@JsonProperty(value="columnName") String columnName) {
        this.columnName = columnName;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.columnName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SystemColumnHandle other = (SystemColumnHandle)obj;
        return Objects.equal((Object)this.columnName, (Object)other.columnName);
    }

    public String toString() {
        return "system:" + this.columnName;
    }

    public static Map<String, ConnectorColumnHandle> toSystemColumnHandles(ConnectorTableMetadata tableMetadata) {
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            columnHandles.put((Object)columnMetadata.getName(), (Object)new SystemColumnHandle(columnMetadata.getName()));
        }
        return columnHandles.build();
    }
}

