/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.informationSchema;

import com.facebook.presto.connector.informationSchema.InformationSchemaColumnHandle;
import com.facebook.presto.connector.informationSchema.InformationSchemaSplit;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorPartition;
import com.facebook.presto.spi.ConnectorPartitionResult;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.SerializableNativeValue;
import com.facebook.presto.spi.TupleDomain;
import com.facebook.presto.util.Types;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class InformationSchemaSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;

    @Inject
    public InformationSchemaSplitManager(NodeManager nodeManager) {
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
    }

    public ConnectorPartitionResult getPartitions(ConnectorTableHandle table, TupleDomain<ConnectorColumnHandle> tupleDomain) {
        Preconditions.checkNotNull(tupleDomain, (Object)"tupleDomain is null");
        InformationSchemaTableHandle informationSchemaTableHandle = Types.checkType(table, InformationSchemaTableHandle.class, "table");
        Map bindings = tupleDomain.extractNullableFixedValues();
        ImmutableList partitions = ImmutableList.of((Object)new InformationSchemaPartition(informationSchemaTableHandle, bindings));
        return new ConnectorPartitionResult((List)partitions, tupleDomain);
    }

    public ConnectorSplitSource getPartitionSplits(ConnectorTableHandle table, List<ConnectorPartition> partitions) {
        Preconditions.checkNotNull(partitions, (Object)"partitions is null");
        if (partitions.isEmpty()) {
            return new FixedSplitSource("system", (Iterable)ImmutableList.of());
        }
        ConnectorPartition partition = (ConnectorPartition)Iterables.getOnlyElement(partitions);
        InformationSchemaPartition informationSchemaPartition = Types.checkType(partition, InformationSchemaPartition.class, "partition");
        ImmutableList localAddress = ImmutableList.of((Object)this.nodeManager.getCurrentNode().getHostAndPort());
        ImmutableMap.Builder filters = ImmutableMap.builder();
        for (Map.Entry<ConnectorColumnHandle, SerializableNativeValue> entry : informationSchemaPartition.getFilters().entrySet()) {
            InformationSchemaColumnHandle informationSchemaColumnHandle = (InformationSchemaColumnHandle)entry.getKey();
            filters.put((Object)informationSchemaColumnHandle.getColumnName(), (Object)entry.getValue());
        }
        InformationSchemaSplit split = new InformationSchemaSplit(informationSchemaPartition.getTable(), (Map<String, SerializableNativeValue>)filters.build(), (List<HostAddress>)localAddress);
        return new FixedSplitSource("system", (Iterable)ImmutableList.of((Object)split));
    }

    public static class InformationSchemaPartition
    implements ConnectorPartition {
        private final InformationSchemaTableHandle table;
        private final Map<ConnectorColumnHandle, SerializableNativeValue> filters;

        public InformationSchemaPartition(InformationSchemaTableHandle table, Map<ConnectorColumnHandle, SerializableNativeValue> filters) {
            this.table = (InformationSchemaTableHandle)Preconditions.checkNotNull((Object)table, (Object)"table is null");
            this.filters = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(filters, (Object)"filters is null")));
        }

        public InformationSchemaTableHandle getTable() {
            return this.table;
        }

        public String getPartitionId() {
            return this.table.getSchemaTableName().toString();
        }

        public TupleDomain<ConnectorColumnHandle> getTupleDomain() {
            return TupleDomain.withNullableFixedValues(this.filters);
        }

        public Map<ConnectorColumnHandle, SerializableNativeValue> getFilters() {
            return this.filters;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("table", (Object)this.table).add("filters", this.filters).toString();
        }
    }
}

