/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.expression;

import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.FieldDefinition;
import com.facebook.presto.byteCode.ParameterizedType;
import com.facebook.presto.byteCode.expression.ByteCodeExpressions;
import com.facebook.presto.byteCode.expression.CastByteCodeExpression;
import com.facebook.presto.byteCode.expression.GetElementByteCodeExpression;
import com.facebook.presto.byteCode.expression.GetFieldByteCodeExpression;
import com.facebook.presto.byteCode.expression.InvokeByteCodeExpression;
import com.facebook.presto.byteCode.expression.PopByteCodeExpression;
import com.facebook.presto.byteCode.expression.ReturnByteCodeExpression;
import com.facebook.presto.byteCode.expression.SetFieldByteCodeExpression;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import org.objectweb.asm.MethodVisitor;

public abstract class ByteCodeExpression
implements ByteCodeNode {
    private final ParameterizedType type;

    protected ByteCodeExpression(ParameterizedType type) {
        this.type = (ParameterizedType)Preconditions.checkNotNull((Object)type, (Object)"type is null");
    }

    public final ParameterizedType getType() {
        return this.type;
    }

    public abstract ByteCodeNode getByteCode();

    protected abstract String formatOneLine();

    public final String toString() {
        return this.formatOneLine() + (this.type.getPrimitiveType() == Void.TYPE ? ";" : "");
    }

    public final ByteCodeExpression getField(Class<?> declaringClass, String name) {
        return new GetFieldByteCodeExpression(this, declaringClass, name);
    }

    public final ByteCodeExpression getField(String name, Class<?> type) {
        return new GetFieldByteCodeExpression(this, this.getType(), name, ParameterizedType.type(type));
    }

    public final ByteCodeExpression getField(Field field) {
        return new GetFieldByteCodeExpression(this, field);
    }

    public final ByteCodeExpression getField(FieldDefinition field) {
        return new GetFieldByteCodeExpression(this, field);
    }

    public final ByteCodeExpression getField(ParameterizedType declaringClass, String name, ParameterizedType type) {
        return new GetFieldByteCodeExpression(this, declaringClass, name, type);
    }

    public final ByteCodeExpression setField(String name, ByteCodeExpression value) {
        return new SetFieldByteCodeExpression(this, this.getType(), name, value);
    }

    public final ByteCodeExpression setField(Field field, ByteCodeExpression value) {
        return new SetFieldByteCodeExpression(this, field, value);
    }

    public final ByteCodeExpression setField(FieldDefinition field, ByteCodeExpression value) {
        return new SetFieldByteCodeExpression(this, field, value);
    }

    public final ByteCodeExpression cast(Class<?> type) {
        return new CastByteCodeExpression(this, ParameterizedType.type(type));
    }

    public final ByteCodeExpression cast(ParameterizedType type) {
        return new CastByteCodeExpression(this, type);
    }

    public final ByteCodeExpression invoke(String methodName, Class<?> returnType, ByteCodeExpression ... parameters) {
        return this.invoke(methodName, ParameterizedType.type(returnType), (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)parameters, (Object)"parameters is null"))));
    }

    public final ByteCodeExpression invoke(String methodName, Class<?> returnType, Iterable<? extends ByteCodeExpression> parameters) {
        return this.invoke(methodName, ParameterizedType.type(returnType), parameters);
    }

    public final ByteCodeExpression invoke(String methodName, ParameterizedType returnType, Iterable<? extends ByteCodeExpression> parameters) {
        return this.invoke(methodName, returnType, (Iterable<ParameterizedType>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)((Iterable)Preconditions.checkNotNull(parameters, (Object)"parameters is null")), ByteCodeExpression.typeGetter())), parameters);
    }

    public final ByteCodeExpression invoke(String methodName, Class<?> returnType, Iterable<? extends Class<?>> parameterTypes, ByteCodeExpression ... parameters) {
        return this.invoke(methodName, ParameterizedType.type(returnType), (Iterable<ParameterizedType>)Iterables.transform(parameterTypes, ParameterizedType.toParameterizedType()), (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)parameters, (Object)"parameters is null"))));
    }

    public final ByteCodeExpression invoke(String methodName, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, ByteCodeExpression ... parameters) {
        return this.invoke(methodName, returnType, parameterTypes, (Iterable<? extends ByteCodeExpression>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)parameters, (Object)"parameters is null"))));
    }

    public final ByteCodeExpression invoke(String methodName, ParameterizedType returnType, Iterable<ParameterizedType> parameterTypes, Iterable<? extends ByteCodeExpression> parameters) {
        return InvokeByteCodeExpression.createInvoke(this, methodName, returnType, parameterTypes, parameters);
    }

    public final ByteCodeExpression getElement(int index) {
        return new GetElementByteCodeExpression(this, ByteCodeExpressions.constantInt(index));
    }

    public final ByteCodeExpression getElement(ByteCodeExpression index) {
        return new GetElementByteCodeExpression(this, index);
    }

    public final ByteCodeExpression ret() {
        return new ReturnByteCodeExpression(this);
    }

    public final ByteCodeExpression pop() {
        if (this.getType().getPrimitiveType() == Void.TYPE) {
            return this;
        }
        return new PopByteCodeExpression(this);
    }

    @Override
    public final void accept(MethodVisitor visitor) {
        this.getByteCode().accept(visitor);
    }

    @Override
    public final <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitByteCodeExpression(parent, this);
    }

    public static Function<ByteCodeExpression, ParameterizedType> typeGetter() {
        return new Function<ByteCodeExpression, ParameterizedType>(){

            public ParameterizedType apply(ByteCodeExpression byteCodeExpression) {
                return byteCodeExpression.getType();
            }
        };
    }
}

