/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.byteCode.control;

import com.facebook.presto.byteCode.Block;
import com.facebook.presto.byteCode.ByteCodeNode;
import com.facebook.presto.byteCode.ByteCodeNodeFactory;
import com.facebook.presto.byteCode.ByteCodeNodes;
import com.facebook.presto.byteCode.ByteCodeVisitor;
import com.facebook.presto.byteCode.CompilerContext;
import com.facebook.presto.byteCode.ExpectedType;
import com.facebook.presto.byteCode.control.FlowControl;
import com.facebook.presto.byteCode.instruction.LabelNode;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;

public class DoWhileLoop
implements FlowControl {
    private final CompilerContext context;
    private final String comment;
    private final Block body;
    private final Block condition;
    private final LabelNode beginLabel = new LabelNode("begin");
    private final LabelNode continueLabel;
    private final LabelNode endLabel;

    public static DoWhileLoopBuilder doWhileLoopBuilder(CompilerContext context) {
        return new DoWhileLoopBuilder(context);
    }

    private DoWhileLoop(CompilerContext context, String comment, Block body, Block condition, LabelNode continueLabel, LabelNode endLabel) {
        this.context = context;
        this.comment = comment;
        this.body = body;
        this.condition = condition;
        this.continueLabel = continueLabel;
        this.endLabel = endLabel;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void accept(MethodVisitor visitor) {
        Block block = new Block(this.context).visitLabel(this.beginLabel).append(this.body).visitLabel(this.continueLabel).append(this.condition).ifZeroGoto(this.endLabel).gotoLabel(this.beginLabel).visitLabel(this.endLabel);
        block.accept(visitor);
    }

    @Override
    public List<ByteCodeNode> getChildNodes() {
        return ImmutableList.of((Object)this.body, (Object)this.condition);
    }

    @Override
    public <T> T accept(ByteCodeNode parent, ByteCodeVisitor<T> visitor) {
        return visitor.visitDoWhile(parent, this);
    }

    public static class DoWhileLoopBuilder {
        private final CompilerContext context;
        private final LabelNode continueLabel = new LabelNode("continue");
        private final LabelNode endLabel = new LabelNode("end");
        private String comment;
        private Block body;
        private Block condition;

        public DoWhileLoopBuilder(CompilerContext context) {
            this.context = context;
            context.pushIterationScope(this.continueLabel, this.endLabel);
        }

        public DoWhileLoopBuilder comment(String format, Object ... args) {
            this.comment = String.format(format, args);
            return this;
        }

        public DoWhileLoopBuilder body(ByteCodeNodeFactory body) {
            this.body = ByteCodeNodes.buildBlock(this.context, body, ExpectedType.VOID, "body");
            return this;
        }

        public DoWhileLoopBuilder condition(ByteCodeNodeFactory condition) {
            this.condition = ByteCodeNodes.buildBlock(this.context, condition, ExpectedType.BOOLEAN, "condition");
            return this;
        }

        public DoWhileLoop build() {
            DoWhileLoop doWhileLoop = new DoWhileLoop(this.context, this.comment, this.body, this.condition, this.continueLabel, this.endLabel);
            this.context.popIterationScope();
            return doWhileLoop;
        }
    }
}

