/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block.snappy;

import com.facebook.presto.block.snappy.SnappyBlockEncoding;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncoding;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.util.Arrays;
import javax.annotation.concurrent.GuardedBy;
import org.iq80.snappy.Snappy;

public class SnappyBlock
implements Block {
    private static final DataSize ENCODING_BUFFER_OVERHEAD = new DataSize(1.0, DataSize.Unit.KILOBYTE);
    private final int positionCount;
    private final Slice compressedSlice;
    private final BlockEncoding uncompressedBlockEncoding;
    @GuardedBy(value="this")
    private Block uncompressedBlock;

    public SnappyBlock(int positionCount, Slice compressedSlice, BlockEncoding uncompressedBlockEncoding) {
        Preconditions.checkArgument((positionCount >= 0 ? 1 : 0) != 0, (Object)"positionCount is negative");
        this.positionCount = positionCount;
        this.compressedSlice = (Slice)Preconditions.checkNotNull((Object)compressedSlice, (Object)"compressedSlice is null");
        this.uncompressedBlockEncoding = (BlockEncoding)Preconditions.checkNotNull((Object)uncompressedBlockEncoding, (Object)"uncompressedBlockEncoding is null");
    }

    public SnappyBlock(Block block) {
        this.positionCount = block.getPositionCount();
        this.uncompressedBlock = block;
        this.uncompressedBlockEncoding = block.getEncoding();
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(Ints.checkedCast((long)((long)this.uncompressedBlock.getSizeInBytes() + ENCODING_BUFFER_OVERHEAD.toBytes())));
        this.uncompressedBlockEncoding.writeBlock((SliceOutput)sliceOutput, this.uncompressedBlock);
        Slice uncompressedSlice = sliceOutput.slice();
        byte[] compressedBytes = new byte[Snappy.maxCompressedLength((int)uncompressedSlice.length())];
        int actualLength = Snappy.compress((byte[])uncompressedSlice.getBytes(), (int)0, (int)uncompressedSlice.length(), (byte[])compressedBytes, (int)0);
        this.compressedSlice = Slices.wrappedBuffer((byte[])Arrays.copyOf(compressedBytes, actualLength));
    }

    public Slice getCompressedSlice() {
        return this.compressedSlice;
    }

    public synchronized Block getUncompressedBlock() {
        if (this.uncompressedBlock == null) {
            int uncompressedLength = Snappy.getUncompressedLength((byte[])this.compressedSlice.getBytes(), (int)0);
            Preconditions.checkState((uncompressedLength > 0 ? 1 : 0) != 0, (Object)"Empty block encountered!");
            byte[] output = new byte[uncompressedLength];
            Snappy.uncompress((byte[])this.compressedSlice.getBytes(), (int)0, (int)this.compressedSlice.length(), (byte[])output, (int)0);
            this.uncompressedBlock = this.uncompressedBlockEncoding.readBlock((SliceInput)Slices.wrappedBuffer((byte[])output).getInput());
        }
        return this.uncompressedBlock;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public int getSizeInBytes() {
        return this.getUncompressedBlock().getSizeInBytes();
    }

    public SnappyBlockEncoding getEncoding() {
        return new SnappyBlockEncoding(this.uncompressedBlockEncoding);
    }

    public Block getRegion(int positionOffset, int length) {
        return this.getUncompressedBlock().getRegion(positionOffset, length);
    }

    public int getLength(int position) {
        return this.getUncompressedBlock().getLength(position);
    }

    public byte getByte(int position, int offset) {
        return this.getUncompressedBlock().getByte(position, offset);
    }

    public short getShort(int position, int offset) {
        return this.getUncompressedBlock().getShort(position, offset);
    }

    public int getInt(int position, int offset) {
        return this.getUncompressedBlock().getInt(position, offset);
    }

    public long getLong(int position, int offset) {
        return this.getUncompressedBlock().getLong(position, offset);
    }

    public float getFloat(int position, int offset) {
        return this.getUncompressedBlock().getFloat(position, offset);
    }

    public double getDouble(int position, int offset) {
        return this.getUncompressedBlock().getDouble(position, offset);
    }

    public Slice getSlice(int position, int offset, int length) {
        return this.getUncompressedBlock().getSlice(position, offset, length);
    }

    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        return this.getUncompressedBlock().bytesEqual(position, offset, otherSlice, otherOffset, length);
    }

    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        return this.getUncompressedBlock().bytesCompare(position, offset, length, otherSlice, otherOffset, otherLength);
    }

    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.getUncompressedBlock().writeBytesTo(position, offset, length, blockBuilder);
    }

    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        return this.getUncompressedBlock().equals(position, offset, otherBlock, otherPosition, otherOffset, length);
    }

    public int hash(int position, int offset, int length) {
        return this.getUncompressedBlock().hash(position, offset, length);
    }

    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        return this.getUncompressedBlock().compareTo(leftPosition, leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    public Block getSingleValueBlock(int position) {
        return this.getUncompressedBlock().getSingleValueBlock(position);
    }

    public boolean isNull(int position) {
        return this.getUncompressedBlock().isNull(position);
    }

    public void assureLoaded() {
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("positionCount", this.positionCount).add("compressedSlice", (Object)this.compressedSlice).toString();
    }
}

