/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util.array;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.util.array.ObjectBigArray;

public final class BlockBigArray {
    private final ObjectBigArray<Block> array;
    private long sizeOfBlocks;

    public BlockBigArray() {
        this.array = new ObjectBigArray();
    }

    public BlockBigArray(Block block) {
        this.array = new ObjectBigArray(block);
    }

    public long sizeOf() {
        return this.array.sizeOf() + this.sizeOfBlocks;
    }

    public Block get(long index) {
        return this.array.get(index);
    }

    public void set(long index, Block value) {
        Block currentValue = this.array.get(index);
        if (currentValue != null) {
            this.sizeOfBlocks -= (long)currentValue.getSizeInBytes();
        }
        if (value != null) {
            this.sizeOfBlocks += (long)value.getSizeInBytes();
        }
        this.array.set(index, value);
    }

    public void ensureCapacity(long length) {
        this.array.ensureCapacity(length);
    }
}

