/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.google.common.base.Preconditions;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.Request;
import io.airlift.node.NodeInfo;
import javax.inject.Inject;

public class NodeIdUserAgentRequestFilter
implements HttpRequestFilter {
    private final String nodeId;

    @Inject
    public NodeIdUserAgentRequestFilter(NodeInfo nodeInfo) {
        Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        this.nodeId = (String)Preconditions.checkNotNull((Object)nodeInfo.getNodeId(), (Object)"nodeId is null");
    }

    public Request filterRequest(Request request) {
        Preconditions.checkNotNull((Object)request, (Object)"request is null");
        return Request.Builder.fromRequest((Request)request).addHeader("User-Agent", this.nodeId).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.nodeId.equals(((NodeIdUserAgentRequestFilter)obj).nodeId);
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }
}

