/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.util.MoreFunctions;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;

public class MapTransformer<K, V> {
    private final Map<K, V> map;

    public static <K, V> MapTransformer<K, V> of(Map<K, V> map) {
        return new MapTransformer<K, V>(map);
    }

    public MapTransformer(Map<K, V> map) {
        this.map = map;
    }

    public <V1> MapTransformer<K, V1> transformValues(Function<V, V1> function) {
        return new MapTransformer<K, V>(Maps.transformValues(this.map, function));
    }

    public MapTransformer<K, V> filterValues(Predicate<? super V> predicate) {
        return new MapTransformer<K, V>(Maps.filterValues(this.map, predicate));
    }

    public <V1 extends V> MapTransformer<K, V1> castValues(Class<V1> clazz) {
        return this.transformValues(MoreFunctions.cast(clazz));
    }

    public Map<K, V> map() {
        return this.map;
    }

    public MapTransformer<V, K> inverse() {
        return new MapTransformer<K, V>(ImmutableBiMap.copyOf(this.map).inverse());
    }

    public BiMap<K, V> biMap() {
        return ImmutableBiMap.copyOf(this.map);
    }

    public Map<K, V> immutableMap() {
        return ImmutableMap.copyOf(this.map);
    }
}

