/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.util.BoundedExecutor;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class KeyBoundedExecutor<T> {
    @GuardedBy(value="this")
    private final Map<T, CountedReference<BoundedExecutor>> executors = new HashMap<T, CountedReference<BoundedExecutor>>();
    private final ExecutorService executorService;
    private final int maxThreads;

    public KeyBoundedExecutor(ExecutorService executorService) {
        this(executorService, 1);
    }

    public KeyBoundedExecutor(ExecutorService executorService, int maxThreads) {
        Preconditions.checkArgument((maxThreads > 0 ? 1 : 0) != 0, (Object)"maxThreads must be greater than zero");
        this.executorService = (ExecutorService)Preconditions.checkNotNull((Object)executorService, (Object)"executorService is null");
        this.maxThreads = maxThreads;
    }

    public synchronized boolean isActive(T key) {
        return this.executors.containsKey(key);
    }

    public void execute(final T key, final Runnable task) {
        final CountedReference<BoundedExecutor> reference = this.acquireExecutor(key);
        reference.get().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    task.run();
                }
                finally {
                    KeyBoundedExecutor.this.returnExecutor(key, reference);
                }
            }
        });
    }

    private synchronized CountedReference<BoundedExecutor> acquireExecutor(T key) {
        CountedReference<BoundedExecutor> reference = this.executors.get(key);
        if (reference == null) {
            reference = new CountedReference(new BoundedExecutor(this.executorService, this.maxThreads));
            this.executors.put(key, reference);
        } else {
            reference.increment();
        }
        return reference;
    }

    private synchronized void returnExecutor(T key, CountedReference<BoundedExecutor> reference) {
        reference.decrement();
        if (!reference.isReferenced()) {
            this.executors.remove(key);
        }
    }

    @NotThreadSafe
    private static class CountedReference<T> {
        private final T reference;
        private int count = 1;

        private CountedReference(T reference) {
            this.reference = Preconditions.checkNotNull(reference, (Object)"reference is null");
        }

        public boolean isReferenced() {
            return this.count > 0;
        }

        public void increment() {
            Preconditions.checkState((boolean)this.isReferenced(), (String)"Reference counter misused: %s", (Object[])new Object[]{this.count});
            ++this.count;
        }

        public void decrement() {
            Preconditions.checkState((boolean)this.isReferenced(), (String)"Reference counter misused: %s", (Object[])new Object[]{this.count});
            --this.count;
        }

        public T get() {
            return this.reference;
        }
    }
}

