/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.util.MapTransformer;
import com.facebook.presto.util.NestedIterableTransformer;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class IterableTransformer<E> {
    private final Iterable<E> iterable;

    IterableTransformer(Iterable<E> iterable) {
        this.iterable = iterable;
    }

    public static <T> IterableTransformer<T> on(Iterable<T> iterable) {
        return new IterableTransformer<T>(iterable);
    }

    public static <T> IterableTransformer<T> on(T[] array) {
        return new IterableTransformer<T>(Arrays.asList(array));
    }

    public <T> IterableTransformer<T> transform(Function<? super E, T> function) {
        return new IterableTransformer<E>(Iterables.transform(this.iterable, function));
    }

    public <T> IterableTransformer<T> cast(final Class<T> clazz) {
        return new IterableTransformer<E>(Iterables.transform(this.iterable, (Function)new Function<E, T>(){

            public T apply(E input) {
                return clazz.cast(input);
            }
        }));
    }

    public <T> IterableTransformer<T> transformAndFlatten(Function<? super E, ? extends Iterable<T>> function) {
        return new IterableTransformer<E>(Iterables.concat((Iterable)Iterables.transform(this.iterable, function)));
    }

    public <T> NestedIterableTransformer<T> transformNested(Function<? super E, ? extends Iterable<T>> function) {
        return new NestedIterableTransformer(Iterables.transform(this.iterable, function));
    }

    public IterableTransformer<E> select(Predicate<? super E> predicate) {
        return new IterableTransformer<E>(Iterables.filter(this.iterable, predicate));
    }

    public IterableTransformer<E> orderBy(Comparator<E> ordering) {
        return new IterableTransformer<E>(Ordering.from(ordering).sortedCopy(this.iterable));
    }

    public boolean all(Predicate<E> predicate) {
        return Iterables.all(this.iterable, predicate);
    }

    public boolean any(Predicate<E> predicate) {
        return Iterables.any(this.iterable, predicate);
    }

    public <K> MapTransformer<K, E> uniqueIndex(Function<? super E, K> keyFunction) {
        return new MapTransformer(Maps.uniqueIndex(this.iterable, keyFunction));
    }

    public <K> Multimap<K, E> index(Function<? super E, K> keyFunction) {
        return Multimaps.index(this.iterable, keyFunction);
    }

    public <V> MapTransformer<E, V> toMap(Function<? super E, V> valueFunction) {
        return new MapTransformer(Maps.toMap(this.iterable, valueFunction));
    }

    public List<E> list() {
        return ImmutableList.copyOf(this.iterable);
    }

    public Set<E> set() {
        return ImmutableSet.copyOf(this.iterable);
    }

    public Multiset<E> bag() {
        return ImmutableMultiset.copyOf(this.iterable);
    }

    public Iterable<E> all() {
        return this.iterable;
    }

    public E first() {
        return (E)Iterables.getFirst(this.iterable, null);
    }

    public E only() {
        return (E)Iterables.getOnlyElement(this.iterable);
    }

    public E last() {
        return (E)Iterables.getLast(this.iterable);
    }
}

