/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.SqlIntervalDayTime;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.util.DateTimeZoneIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import org.joda.time.format.PeriodParser;

public final class DateTimeUtils {
    private static final DateTimeFormatter DATE_FORMATTER = ISODateTimeFormat.date().withZoneUTC();
    private static final DateTimeFormatter TIMESTAMP_FORMATTER;
    private static final DateTimeFormatter TIMESTAMP_WITH_TIME_ZONE_FORMATTER;
    private static final DateTimeFormatter TIME_FORMATTER;
    private static final DateTimeFormatter TIME_WITH_TIME_ZONE_FORMATTER;
    private static final int YEAR_FIELD = 0;
    private static final int MONTH_FIELD = 1;
    private static final int DAY_FIELD = 3;
    private static final int HOUR_FIELD = 4;
    private static final int MINUTE_FIELD = 5;
    private static final int SECOND_FIELD = 6;
    private static final int MILLIS_FIELD = 7;
    private static final PeriodFormatter INTERVAL_DAY_SECOND_FORMATTER;
    private static final PeriodFormatter INTERVAL_DAY_MINUTE_FORMATTER;
    private static final PeriodFormatter INTERVAL_DAY_HOUR_FORMATTER;
    private static final PeriodFormatter INTERVAL_DAY_FORMATTER;
    private static final PeriodFormatter INTERVAL_HOUR_SECOND_FORMATTER;
    private static final PeriodFormatter INTERVAL_HOUR_MINUTE_FORMATTER;
    private static final PeriodFormatter INTERVAL_HOUR_FORMATTER;
    private static final PeriodFormatter INTERVAL_MINUTE_SECOND_FORMATTER;
    private static final PeriodFormatter INTERVAL_MINUTE_FORMATTER;
    private static final PeriodFormatter INTERVAL_SECOND_FORMATTER;
    private static final PeriodFormatter INTERVAL_YEAR_MONTH_FORMATTER;
    private static final PeriodFormatter INTERVAL_YEAR_FORMATTER;
    private static final PeriodFormatter INTERVAL_MONTH_FORMATTER;

    private DateTimeUtils() {
    }

    public static long parseDate(String value) {
        return DATE_FORMATTER.parseMillis(value);
    }

    public static String printDate(long millis) {
        return DATE_FORMATTER.print(millis);
    }

    public static long parseTimestamp(TimeZoneKey timeZoneKey, String value) {
        try {
            return DateTimeUtils.parseTimestampWithTimeZone(value);
        }
        catch (Exception e) {
            return DateTimeUtils.parseTimestampWithoutTimeZone(timeZoneKey, value);
        }
    }

    public static long parseTimestampWithTimeZone(String timestampWithTimeZone) {
        DateTime dateTime = TIMESTAMP_WITH_TIME_ZONE_FORMATTER.parseDateTime(timestampWithTimeZone);
        return DateTimeZoneIndex.packDateTimeWithZone(dateTime);
    }

    public static long parseTimestampWithoutTimeZone(TimeZoneKey timeZoneKey, String value) {
        return TIMESTAMP_FORMATTER.withZone(DateTimeZoneIndex.getDateTimeZone(timeZoneKey)).parseMillis(value);
    }

    public static String printTimestampWithTimeZone(long timestampWithTimeZone) {
        DateTimeZone timeZone = DateTimeZoneIndex.unpackDateTimeZone(timestampWithTimeZone);
        long millis = DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone);
        return TIMESTAMP_WITH_TIME_ZONE_FORMATTER.withZone(timeZone).print(millis);
    }

    public static String printTimestampWithoutTimeZone(TimeZoneKey timeZoneKey, long timestamp) {
        return TIMESTAMP_FORMATTER.withZone(DateTimeZoneIndex.getDateTimeZone(timeZoneKey)).print(timestamp);
    }

    public static boolean timestampHasTimeZone(String value) {
        try {
            DateTimeUtils.parseTimestampWithTimeZone(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static long parseTime(TimeZoneKey timeZoneKey, String value) {
        try {
            return DateTimeUtils.parseTimeWithTimeZone(value);
        }
        catch (Exception e) {
            return DateTimeUtils.parseTimeWithoutTimeZone(timeZoneKey, value);
        }
    }

    public static long parseTimeWithTimeZone(String timeWithTimeZone) {
        DateTime dateTime = TIME_WITH_TIME_ZONE_FORMATTER.parseDateTime(timeWithTimeZone);
        return DateTimeZoneIndex.packDateTimeWithZone(dateTime);
    }

    public static long parseTimeWithoutTimeZone(TimeZoneKey timeZoneKey, String value) {
        return TIME_FORMATTER.withZone(DateTimeZoneIndex.getDateTimeZone(timeZoneKey)).parseMillis(value);
    }

    public static String printTimeWithTimeZone(long timeWithTimeZone) {
        DateTimeZone timeZone = DateTimeZoneIndex.unpackDateTimeZone(timeWithTimeZone);
        long millis = DateTimeEncoding.unpackMillisUtc((long)timeWithTimeZone);
        return TIME_WITH_TIME_ZONE_FORMATTER.withZone(timeZone).print(millis);
    }

    public static String printTimeWithoutTimeZone(TimeZoneKey timeZoneKey, long value) {
        return TIME_FORMATTER.withZone(DateTimeZoneIndex.getDateTimeZone(timeZoneKey)).print(value);
    }

    public static boolean timeHasTimeZone(String value) {
        try {
            DateTimeUtils.parseTimeWithTimeZone(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static long parseDayTimeInterval(String value, IntervalLiteral.IntervalField startField, IntervalLiteral.IntervalField endField) {
        if (endField == null) {
            endField = startField;
        }
        if (startField == IntervalLiteral.IntervalField.DAY && endField == IntervalLiteral.IntervalField.SECOND) {
            return DateTimeUtils.parsePeriodMillis(INTERVAL_DAY_SECOND_FORMATTER, value, startField, endField);
        }
        if (startField == IntervalLiteral.IntervalField.DAY && endField == IntervalLiteral.IntervalField.MINUTE) {
            return DateTimeUtils.parsePeriodMillis(INTERVAL_DAY_MINUTE_FORMATTER, value, startField, endField);
        }
        if (startField == IntervalLiteral.IntervalField.DAY && endField == IntervalLiteral.IntervalField.HOUR) {
            return DateTimeUtils.parsePeriodMillis(INTERVAL_DAY_HOUR_FORMATTER, value, startField, endField);
        }
        if (startField == IntervalLiteral.IntervalField.DAY && endField == IntervalLiteral.IntervalField.DAY) {
            return DateTimeUtils.parsePeriodMillis(INTERVAL_DAY_FORMATTER, value, startField, endField);
        }
        if (startField == IntervalLiteral.IntervalField.HOUR && endField == IntervalLiteral.IntervalField.SECOND) {
            return DateTimeUtils.parsePeriodMillis(INTERVAL_HOUR_SECOND_FORMATTER, value, startField, endField);
        }
        if (startField == IntervalLiteral.IntervalField.HOUR && endField == IntervalLiteral.IntervalField.MINUTE) {
            return DateTimeUtils.parsePeriodMillis(INTERVAL_HOUR_MINUTE_FORMATTER, value, startField, endField);
        }
        if (startField == IntervalLiteral.IntervalField.HOUR && endField == IntervalLiteral.IntervalField.HOUR) {
            return DateTimeUtils.parsePeriodMillis(INTERVAL_HOUR_FORMATTER, value, startField, endField);
        }
        if (startField == IntervalLiteral.IntervalField.MINUTE && endField == IntervalLiteral.IntervalField.SECOND) {
            return DateTimeUtils.parsePeriodMillis(INTERVAL_MINUTE_SECOND_FORMATTER, value, startField, endField);
        }
        if (startField == IntervalLiteral.IntervalField.MINUTE && endField == IntervalLiteral.IntervalField.MINUTE) {
            return DateTimeUtils.parsePeriodMillis(INTERVAL_MINUTE_FORMATTER, value, startField, endField);
        }
        if (startField == IntervalLiteral.IntervalField.SECOND && endField == IntervalLiteral.IntervalField.SECOND) {
            return DateTimeUtils.parsePeriodMillis(INTERVAL_SECOND_FORMATTER, value, startField, endField);
        }
        throw new IllegalArgumentException("Invalid day second interval qualifier: " + startField + " to " + endField);
    }

    public static long parsePeriodMillis(PeriodFormatter periodFormatter, String value, IntervalLiteral.IntervalField startField, IntervalLiteral.IntervalField endField) {
        Period period = DateTimeUtils.parsePeriod(periodFormatter, value, startField, endField);
        return SqlIntervalDayTime.toMillis((int)period.getValue(3), (int)period.getValue(4), (int)period.getValue(5), (int)period.getValue(6), (int)period.getValue(7));
    }

    public static String printDayTimeInterval(long millis) {
        return SqlIntervalDayTime.formatMillis((long)millis);
    }

    public static long parseYearMonthInterval(String value, IntervalLiteral.IntervalField startField, IntervalLiteral.IntervalField endField) {
        if (endField == null) {
            endField = startField;
        }
        if (startField == IntervalLiteral.IntervalField.YEAR && endField == IntervalLiteral.IntervalField.MONTH) {
            PeriodFormatter periodFormatter = INTERVAL_YEAR_MONTH_FORMATTER;
            return DateTimeUtils.parsePeriodMonths(value, periodFormatter, startField, endField);
        }
        if (startField == IntervalLiteral.IntervalField.YEAR && endField == IntervalLiteral.IntervalField.YEAR) {
            return DateTimeUtils.parsePeriodMonths(value, INTERVAL_YEAR_FORMATTER, startField, endField);
        }
        if (startField == IntervalLiteral.IntervalField.MONTH && endField == IntervalLiteral.IntervalField.MONTH) {
            return DateTimeUtils.parsePeriodMonths(value, INTERVAL_MONTH_FORMATTER, startField, endField);
        }
        throw new IllegalArgumentException("Invalid year month interval qualifier: " + startField + " to " + endField);
    }

    private static long parsePeriodMonths(String value, PeriodFormatter periodFormatter, IntervalLiteral.IntervalField startField, IntervalLiteral.IntervalField endField) {
        Period period = DateTimeUtils.parsePeriod(periodFormatter, value, startField, endField);
        return period.getValue(0) * 12 + period.getValue(1);
    }

    public static String printYearMonthInterval(long months) {
        return months / 12L + "-" + months % 12L;
    }

    private static Period parsePeriod(PeriodFormatter periodFormatter, String value, IntervalLiteral.IntervalField startField, IntervalLiteral.IntervalField endField) {
        try {
            return periodFormatter.parsePeriod(value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid INTERVAL " + startField + " to " + endField + " value: " + value, e);
        }
    }

    private static PeriodFormatter cretePeriodFormatter(IntervalLiteral.IntervalField startField, IntervalLiteral.IntervalField endField) {
        if (endField == null) {
            endField = startField;
        }
        ArrayList<PeriodParser> parsers = new ArrayList<PeriodParser>();
        PeriodFormatterBuilder builder = new PeriodFormatterBuilder();
        switch (startField) {
            case YEAR: {
                builder.appendYears();
                parsers.add(builder.toParser());
                if (endField == IntervalLiteral.IntervalField.YEAR) break;
                builder.appendLiteral("-");
            }
            case MONTH: {
                builder.appendMonths();
                parsers.add(builder.toParser());
                if (endField == IntervalLiteral.IntervalField.MONTH) break;
                throw new IllegalArgumentException("Invalid interval qualifier: " + startField + " to " + endField);
            }
            case DAY: {
                builder.appendDays();
                parsers.add(builder.toParser());
                if (endField == IntervalLiteral.IntervalField.DAY) break;
                builder.appendLiteral(" ");
            }
            case HOUR: {
                builder.appendHours();
                parsers.add(builder.toParser());
                if (endField == IntervalLiteral.IntervalField.HOUR) break;
                builder.appendLiteral(":");
            }
            case MINUTE: {
                builder.appendMinutes();
                parsers.add(builder.toParser());
                if (endField == IntervalLiteral.IntervalField.MINUTE) break;
                builder.appendLiteral(":");
            }
            case SECOND: {
                builder.appendSecondsWithOptionalMillis();
                parsers.add(builder.toParser());
            }
        }
        return new PeriodFormatter(builder.toPrinter(), (PeriodParser)new OrderedPeriodParser(parsers));
    }

    static {
        DateTimeParser[] timestampWithoutTimeZoneParser = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyy-M-d").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSS").getParser()};
        DateTimePrinter timestampWithoutTimeZonePrinter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS").getPrinter();
        TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().append(timestampWithoutTimeZonePrinter, timestampWithoutTimeZoneParser).toFormatter().withZoneUTC();
        DateTimeParser[] timestampWithTimeZoneParser = new DateTimeParser[]{DateTimeFormat.forPattern((String)"yyyy-M-dZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d Z").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:mZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m Z").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:sZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s Z").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSSZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSS Z").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-dZZZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d ZZZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:mZZZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m ZZZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:sZZZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s ZZZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSSZZZ").getParser(), DateTimeFormat.forPattern((String)"yyyy-M-d H:m:s.SSS ZZZ").getParser()};
        DateTimePrinter timestampWithTimeZonePrinter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS ZZZ").getPrinter();
        TIMESTAMP_WITH_TIME_ZONE_FORMATTER = new DateTimeFormatterBuilder().append(timestampWithTimeZonePrinter, timestampWithTimeZoneParser).toFormatter().withOffsetParsed();
        DateTimeParser[] timeWithoutTimeZoneParser = new DateTimeParser[]{DateTimeFormat.forPattern((String)"H:m").getParser(), DateTimeFormat.forPattern((String)"H:m:s").getParser(), DateTimeFormat.forPattern((String)"H:m:s.SSS").getParser()};
        DateTimePrinter timeWithoutTimeZonePrinter = DateTimeFormat.forPattern((String)"HH:mm:ss.SSS").getPrinter();
        TIME_FORMATTER = new DateTimeFormatterBuilder().append(timeWithoutTimeZonePrinter, timeWithoutTimeZoneParser).toFormatter().withZoneUTC();
        DateTimeParser[] timeWithTimeZoneParser = new DateTimeParser[]{DateTimeFormat.forPattern((String)"H:mZ").getParser(), DateTimeFormat.forPattern((String)"H:m Z").getParser(), DateTimeFormat.forPattern((String)"H:m:sZ").getParser(), DateTimeFormat.forPattern((String)"H:m:s Z").getParser(), DateTimeFormat.forPattern((String)"H:m:s.SSSZ").getParser(), DateTimeFormat.forPattern((String)"H:m:s.SSS Z").getParser(), DateTimeFormat.forPattern((String)"H:mZZZ").getParser(), DateTimeFormat.forPattern((String)"H:m ZZZ").getParser(), DateTimeFormat.forPattern((String)"H:m:sZZZ").getParser(), DateTimeFormat.forPattern((String)"H:m:s ZZZ").getParser(), DateTimeFormat.forPattern((String)"H:m:s.SSSZZZ").getParser(), DateTimeFormat.forPattern((String)"H:m:s.SSS ZZZ").getParser()};
        DateTimePrinter timeWithTimeZonePrinter = DateTimeFormat.forPattern((String)"HH:mm:ss.SSS ZZZ").getPrinter();
        TIME_WITH_TIME_ZONE_FORMATTER = new DateTimeFormatterBuilder().append(timeWithTimeZonePrinter, timeWithTimeZoneParser).toFormatter().withOffsetParsed();
        INTERVAL_DAY_SECOND_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.DAY, IntervalLiteral.IntervalField.SECOND);
        INTERVAL_DAY_MINUTE_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.DAY, IntervalLiteral.IntervalField.MINUTE);
        INTERVAL_DAY_HOUR_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.DAY, IntervalLiteral.IntervalField.HOUR);
        INTERVAL_DAY_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.DAY, IntervalLiteral.IntervalField.DAY);
        INTERVAL_HOUR_SECOND_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.HOUR, IntervalLiteral.IntervalField.SECOND);
        INTERVAL_HOUR_MINUTE_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.HOUR, IntervalLiteral.IntervalField.MINUTE);
        INTERVAL_HOUR_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.HOUR, IntervalLiteral.IntervalField.HOUR);
        INTERVAL_MINUTE_SECOND_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.MINUTE, IntervalLiteral.IntervalField.SECOND);
        INTERVAL_MINUTE_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.MINUTE, IntervalLiteral.IntervalField.MINUTE);
        INTERVAL_SECOND_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.SECOND, IntervalLiteral.IntervalField.SECOND);
        INTERVAL_YEAR_MONTH_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.YEAR, IntervalLiteral.IntervalField.MONTH);
        INTERVAL_YEAR_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.YEAR, IntervalLiteral.IntervalField.YEAR);
        INTERVAL_MONTH_FORMATTER = DateTimeUtils.cretePeriodFormatter(IntervalLiteral.IntervalField.MONTH, IntervalLiteral.IntervalField.MONTH);
    }

    private static class OrderedPeriodParser
    implements PeriodParser {
        private final List<PeriodParser> parsers;

        private OrderedPeriodParser(List<PeriodParser> parsers) {
            this.parsers = parsers;
        }

        public int parseInto(ReadWritablePeriod period, String text, int position, Locale locale) {
            int bestValidPos = position;
            MutablePeriod bestValidPeriod = null;
            int bestInvalidPos = position;
            for (PeriodParser parser : this.parsers) {
                MutablePeriod parsedPeriod;
                int parsePos = parser.parseInto((ReadWritablePeriod)(parsedPeriod = new MutablePeriod()), text, position, locale);
                if (parsePos >= position) {
                    if (parsePos <= bestValidPos) continue;
                    bestValidPos = parsePos;
                    bestValidPeriod = parsedPeriod;
                    if (parsePos < text.length()) continue;
                    break;
                }
                if (parsePos >= 0 || (parsePos ^= 0xFFFFFFFF) <= bestInvalidPos) continue;
                bestInvalidPos = parsePos;
            }
            if (bestValidPos > position || bestValidPos == position) {
                if (bestValidPeriod != null) {
                    period.setPeriod(bestValidPeriod);
                }
                return bestValidPos;
            }
            return ~bestInvalidPos;
        }
    }
}

