/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.util.List;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static int hashPosition(Type type, Block block, int position) {
        if (block.isNull(position)) {
            return 0;
        }
        return type.hash(block, position);
    }

    public static boolean positionEqualsPosition(Type type, Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        boolean leftIsNull = leftBlock.isNull(leftPosition);
        boolean rightIsNull = rightBlock.isNull(rightPosition);
        if (leftIsNull || rightIsNull) {
            return leftIsNull && rightIsNull;
        }
        return type.equalTo(leftBlock, leftPosition, rightBlock, rightPosition);
    }

    public static Function<Type, String> nameGetter() {
        return new Function<Type, String>(){

            public String apply(Type input) {
                return input.getName();
            }
        };
    }

    public static List<Type> resolveTypes(List<String> typeNames, final TypeManager typeManager) {
        return FluentIterable.from(typeNames).transform((Function)new Function<String, Type>(){

            public Type apply(String type) {
                return (Type)Preconditions.checkNotNull((Object)typeManager.getType(type), (String)"Type '%s' not found", (Object[])new Object[]{type});
            }
        }).toList();
    }
}

