/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.HyperLogLogType;
import com.facebook.presto.spi.type.IntervalDayTimeType;
import com.facebook.presto.spi.type.IntervalYearMonthType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.ColorType;
import com.facebook.presto.type.JsonPathType;
import com.facebook.presto.type.LikePatternType;
import com.facebook.presto.type.RegexpType;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public final class TypeRegistry
implements TypeManager {
    private final ConcurrentMap<String, Type> types = new ConcurrentHashMap<String, Type>();

    public TypeRegistry() {
        this((Set<Type>)ImmutableSet.of());
    }

    @Inject
    public TypeRegistry(Set<Type> types) {
        Preconditions.checkNotNull(types, (Object)"types is null");
        this.types.put(UnknownType.UNKNOWN.getName().toLowerCase(), (Type)UnknownType.UNKNOWN);
        this.addType((Type)BooleanType.BOOLEAN);
        this.addType((Type)BigintType.BIGINT);
        this.addType((Type)DoubleType.DOUBLE);
        this.addType((Type)VarcharType.VARCHAR);
        this.addType((Type)VarbinaryType.VARBINARY);
        this.addType((Type)DateType.DATE);
        this.addType((Type)TimeType.TIME);
        this.addType((Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
        this.addType((Type)TimestampType.TIMESTAMP);
        this.addType((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        this.addType((Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH);
        this.addType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME);
        this.addType((Type)HyperLogLogType.HYPER_LOG_LOG);
        this.addType((Type)RegexpType.REGEXP);
        this.addType((Type)LikePatternType.LIKE_PATTERN);
        this.addType((Type)JsonPathType.JSON_PATH);
        this.addType((Type)ColorType.COLOR);
        for (Type type : types) {
            this.addType(type);
        }
    }

    public Type getType(String typeName) {
        return (Type)this.types.get(typeName.toLowerCase());
    }

    public List<Type> getTypes() {
        return ImmutableList.copyOf(this.types.values());
    }

    public void addType(Type type) {
        TypeRegistry.verifyTypeClass(type);
        Type existingType = this.types.putIfAbsent(type.getName().toLowerCase(), type);
        Preconditions.checkState((existingType == null || existingType.equals(type) ? 1 : 0) != 0, (String)"Type %s is already registered", (Object[])new Object[]{type.getName()});
    }

    public static void verifyTypeClass(Type type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
    }
}

