/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.ScalarOperator;
import com.facebook.presto.spi.type.SqlIntervalDayTime;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class IntervalDayTimeOperators {
    private IntervalDayTimeOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="interval day to second")
    public static long add(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left + right;
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="interval day to second")
    public static long subtract(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left - right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long multiplyByBigint(@SqlType(value="interval day to second") long left, @SqlType(value="bigint") long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long multiplyByDouble(@SqlType(value="interval day to second") long left, @SqlType(value="double") double right) {
        return (long)((double)left * right);
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long bigintMultiply(@SqlType(value="bigint") long left, @SqlType(value="interval day to second") long right) {
        return left * right;
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="interval day to second")
    public static long doubleMultiply(@SqlType(value="double") double left, @SqlType(value="interval day to second") long right) {
        return (long)(left * (double)right);
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="interval day to second")
    public static long divideByDouble(@SqlType(value="interval day to second") long left, @SqlType(value="double") double right) {
        return (long)((double)left / right);
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="interval day to second")
    public static long negate(@SqlType(value="interval day to second") long value) {
        return -value;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="interval day to second") long left, @SqlType(value="interval day to second") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="interval day to second") long value, @SqlType(value="interval day to second") long min, @SqlType(value="interval day to second") long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castToSlice(@SqlType(value="interval day to second") long value) {
        return Slices.copiedBuffer((String)SqlIntervalDayTime.formatMillis((long)value), (Charset)StandardCharsets.UTF_8);
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="interval day to second") long value) {
        return (int)(value ^ value >>> 32);
    }
}

