/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.operator.Page;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.SqlDate;
import com.facebook.presto.spi.type.SqlTime;
import com.facebook.presto.spi.type.SqlTimeWithTimeZone;
import com.facebook.presto.spi.type.SqlTimestamp;
import com.facebook.presto.spi.type.SqlTimestampWithTimeZone;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.MaterializedRow;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MaterializedResult {
    public static final int DEFAULT_PRECISION = 5;
    private final List<MaterializedRow> rows;
    private final List<Type> types;

    public MaterializedResult(List<MaterializedRow> rows, List<? extends Type> types) {
        this.rows = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(rows, (Object)"rows is null")));
        this.types = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(types, (Object)"types is null")));
    }

    public List<MaterializedRow> getMaterializedRows() {
        return this.rows;
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MaterializedResult o = (MaterializedResult)obj;
        return Objects.equal(this.types, o.types) && Objects.equal(this.rows, o.rows);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rows, this.types});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("rows", this.rows).add("types", this.types).toString();
    }

    public MaterializedResult toJdbcTypes() {
        ImmutableList.Builder jdbcRows = ImmutableList.builder();
        for (MaterializedRow row : this.rows) {
            jdbcRows.add((Object)MaterializedResult.convertToJdbcTypes(row));
        }
        return new MaterializedResult((List<MaterializedRow>)jdbcRows.build(), this.types);
    }

    private static MaterializedRow convertToJdbcTypes(MaterializedRow prestoRow) {
        ArrayList<Object> jdbcValues = new ArrayList<Object>();
        for (int field = 0; field < prestoRow.getFieldCount(); ++field) {
            Object prestoValue = prestoRow.getField(field);
            Object jdbcValue = prestoValue instanceof SqlDate ? new Date(((SqlDate)prestoValue).getMillisAtMidnight()) : (prestoValue instanceof SqlTime ? new Time(((SqlTime)prestoValue).getMillisUtc()) : (prestoValue instanceof SqlTimeWithTimeZone ? new Time(((SqlTimeWithTimeZone)prestoValue).getMillisUtc()) : (prestoValue instanceof SqlTimestamp ? new Timestamp(((SqlTimestamp)prestoValue).getMillisUtc()) : (prestoValue instanceof SqlTimestampWithTimeZone ? new Timestamp(((SqlTimestampWithTimeZone)prestoValue).getMillisUtc()) : prestoValue))));
            jdbcValues.add(jdbcValue);
        }
        return new MaterializedRow(prestoRow.getPrecision(), jdbcValues);
    }

    public static Builder resultBuilder(ConnectorSession session, Type ... types) {
        return MaterializedResult.resultBuilder(session, (Iterable<? extends Type>)ImmutableList.copyOf((Object[])types));
    }

    public static Builder resultBuilder(ConnectorSession session, Iterable<? extends Type> types) {
        return new Builder(session, (List<Type>)ImmutableList.copyOf(types));
    }

    public static class Builder {
        private final ConnectorSession session;
        private final List<Type> types;
        private final ImmutableList.Builder<MaterializedRow> rows = ImmutableList.builder();

        Builder(ConnectorSession session, List<Type> types) {
            this.session = session;
            this.types = ImmutableList.copyOf(types);
        }

        public Builder row(Object ... values) {
            this.rows.add((Object)new MaterializedRow(5, values));
            return this;
        }

        public Builder pages(Iterable<Page> pages) {
            for (Page page : pages) {
                this.page(page);
            }
            return this;
        }

        public Builder page(Page page) {
            Preconditions.checkNotNull((Object)page, (Object)"page is null");
            Preconditions.checkArgument((page.getChannelCount() == this.types.size() ? 1 : 0) != 0, (String)"Expected a page with %s columns, but got %s columns", (Object[])new Object[]{this.types.size(), page.getChannelCount()});
            for (int position = 0; position < page.getPositionCount(); ++position) {
                ArrayList<Object> values = new ArrayList(page.getChannelCount());
                for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                    Type type = this.types.get(channel);
                    Block block = page.getBlock(channel);
                    values.add(type.getObjectValue(this.session, block, position));
                }
                values = Collections.unmodifiableList(values);
                this.rows.add((Object)new MaterializedRow(5, values));
            }
            return this;
        }

        public MaterializedResult build() {
            return new MaterializedResult((List<MaterializedRow>)this.rows.build(), this.types);
        }
    }
}

