/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class InputReferenceExpression
extends RowExpression {
    private final int field;
    private final Type type;

    public InputReferenceExpression(int field, Type type) {
        Preconditions.checkNotNull((Object)type, (Object)"type is null");
        this.field = field;
        this.type = type;
    }

    @JsonProperty
    public int getField() {
        return this.field;
    }

    @Override
    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.type);
    }

    @Override
    public String toString() {
        return "#" + this.field;
    }

    @Override
    public <C, R> R accept(RowExpressionVisitor<C, R> visitor, C context) {
        return visitor.visitInputReference(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InputReferenceExpression other = (InputReferenceExpression)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.type, other.type);
    }
}

