/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class RowNumberLimitNode
extends PlanNode {
    private final PlanNode source;
    private final List<Symbol> partitionBy;
    private final int maxRowCountPerPartition;
    private final Symbol rowNumberSymbol;

    @JsonCreator
    public RowNumberLimitNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="partitionBy") List<Symbol> partitionBy, @JsonProperty(value="rowNumberSymbol") Symbol rowNumberSymbol, @JsonProperty(value="maxRowCountPerPartition") int maxRowCountPerPartition) {
        super(id);
        Preconditions.checkNotNull((Object)source, (Object)"source is null");
        Preconditions.checkNotNull(partitionBy, (Object)"partitionBy is null");
        Preconditions.checkArgument((!partitionBy.isEmpty() ? 1 : 0) != 0, (Object)"partitionBy is empty");
        Preconditions.checkNotNull((Object)rowNumberSymbol, (Object)"rowNumberSymbol is null");
        Preconditions.checkArgument((maxRowCountPerPartition > 0 ? 1 : 0) != 0, (Object)"maxRowCountPerPartition must be > 0");
        this.source = source;
        this.partitionBy = ImmutableList.copyOf(partitionBy);
        this.rowNumberSymbol = rowNumberSymbol;
        this.maxRowCountPerPartition = maxRowCountPerPartition;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.source.getOutputSymbols(), (Iterable)ImmutableList.of((Object)this.rowNumberSymbol)));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<Symbol> getPartitionBy() {
        return this.partitionBy;
    }

    @JsonProperty
    public Symbol getRowNumberSymbol() {
        return this.rowNumberSymbol;
    }

    @JsonProperty
    public int getMaxRowCountPerPartition() {
        return this.maxRowCountPerPartition;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitRowNumberLimit(this, context);
    }
}

