/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeRewriter;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;

public class SetFlatteningOptimizer
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, ConnectorSession session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(), plan, false);
    }

    private static class Rewriter
    extends PlanNodeRewriter<Boolean> {
        private Rewriter() {
        }

        @Override
        public PlanNode rewriteNode(PlanNode node, Boolean upstreamDistinct, PlanRewriter<Boolean> planRewriter) {
            return super.rewriteNode(node, false, planRewriter);
        }

        @Override
        public PlanNode rewriteUnion(UnionNode node, Boolean upstreamDistinct, PlanRewriter<Boolean> planRewriter) {
            ImmutableList.Builder flattenedSources = ImmutableList.builder();
            ImmutableListMultimap.Builder flattenedSymbolMap = ImmutableListMultimap.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode subplan = node.getSources().get(i);
                PlanNode rewrittenSource = planRewriter.rewrite(subplan, upstreamDistinct);
                if (rewrittenSource instanceof UnionNode) {
                    UnionNode rewrittenUnion = (UnionNode)rewrittenSource;
                    flattenedSources.addAll(rewrittenUnion.getSources());
                    for (Map.Entry entry : node.getSymbolMapping().asMap().entrySet()) {
                        Symbol inputSymbol = (Symbol)Iterables.get((Iterable)((Iterable)entry.getValue()), (int)i);
                        flattenedSymbolMap.putAll(entry.getKey(), (Iterable)rewrittenUnion.getSymbolMapping().get((Object)inputSymbol));
                    }
                    continue;
                }
                flattenedSources.add((Object)rewrittenSource);
                for (Map.Entry entry : node.getSymbolMapping().asMap().entrySet()) {
                    flattenedSymbolMap.put(entry.getKey(), Iterables.get((Iterable)((Iterable)entry.getValue()), (int)i));
                }
            }
            return new UnionNode(node.getId(), (List<PlanNode>)flattenedSources.build(), (ListMultimap<Symbol, Symbol>)flattenedSymbolMap.build());
        }

        @Override
        public PlanNode rewriteAggregation(AggregationNode node, Boolean upstreamDistinct, PlanRewriter<Boolean> planRewriter) {
            boolean distinct = Rewriter.isDistinctOperator(node);
            PlanNode rewrittenNode = planRewriter.rewrite(node.getSource(), distinct);
            if (upstreamDistinct.booleanValue() && distinct) {
                return rewrittenNode;
            }
            return new AggregationNode(node.getId(), rewrittenNode, node.getGroupBy(), node.getAggregations(), node.getFunctions(), node.getMasks(), node.getSampleWeight(), node.getConfidence());
        }

        private static boolean isDistinctOperator(AggregationNode node) {
            return node.getAggregations().isEmpty();
        }
    }
}

