/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeRewriter;
import com.facebook.presto.sql.planner.plan.PlanRewriter;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CountConstantOptimizer
extends PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, ConnectorSession session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Preconditions.checkNotNull((Object)plan, (Object)"plan is null");
        Preconditions.checkNotNull((Object)session, (Object)"session is null");
        Preconditions.checkNotNull(types, (Object)"types is null");
        Preconditions.checkNotNull((Object)symbolAllocator, (Object)"symbolAllocator is null");
        Preconditions.checkNotNull((Object)idAllocator, (Object)"idAllocator is null");
        return PlanRewriter.rewriteWith(new Rewriter(), plan);
    }

    private static class Rewriter
    extends PlanNodeRewriter<Void> {
        private Rewriter() {
        }

        @Override
        public PlanNode rewriteAggregation(AggregationNode node, Void context, PlanRewriter<Void> planRewriter) {
            LinkedHashMap<Symbol, FunctionCall> aggregations = new LinkedHashMap<Symbol, FunctionCall>(node.getAggregations());
            LinkedHashMap<Symbol, Signature> functions = new LinkedHashMap<Symbol, Signature>(node.getFunctions());
            PlanNode source = planRewriter.rewrite(node.getSource(), context);
            if (source instanceof ProjectNode) {
                ProjectNode projectNode = (ProjectNode)source;
                for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                    Signature signature;
                    Symbol symbol = entry.getKey();
                    FunctionCall functionCall = entry.getValue();
                    if (!Rewriter.isCountConstant(projectNode, functionCall, signature = node.getFunctions().get(symbol))) continue;
                    aggregations.put(symbol, new FunctionCall(functionCall.getName(), null, functionCall.isDistinct(), (List)ImmutableList.of()));
                    functions.put(symbol, new Signature("count", "bigint", new String[0]));
                }
            }
            return new AggregationNode(node.getId(), source, node.getGroupBy(), aggregations, functions, node.getMasks(), node.getStep(), node.getSampleWeight(), node.getConfidence());
        }

        public static boolean isCountConstant(ProjectNode projectNode, FunctionCall functionCall, Signature signature) {
            if (!"count".equals(signature.getName()) || signature.getArgumentTypes().size() != 1 || !signature.getReturnType().equals("bigint")) {
                return false;
            }
            Expression argument = (Expression)functionCall.getArguments().get(0);
            if (argument instanceof Literal) {
                return true;
            }
            if (argument instanceof QualifiedNameReference) {
                QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)argument;
                QualifiedName qualifiedName = qualifiedNameReference.getName();
                Symbol argumentSymbol = Symbol.fromQualifiedName(qualifiedName);
                Expression argumentExpression = projectNode.getOutputMap().get(argumentSymbol);
                return argumentExpression instanceof Literal && !(argumentExpression instanceof NullLiteral);
            }
            return false;
        }
    }
}

