/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.tree.QualifiedName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;

public class Symbol
implements Comparable<Symbol> {
    private final String name;

    @JsonCreator
    public Symbol(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.name = name;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public QualifiedName toQualifiedName() {
        return QualifiedName.of((String)this.name, (String[])new String[0]);
    }

    public static Symbol fromQualifiedName(QualifiedName name) {
        Preconditions.checkArgument((!name.getPrefix().isPresent() ? 1 : 0) != 0, (Object)"Can't create a symbol from a qualified name with prefix");
        return new Symbol(name.getSuffix());
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        return this.name.equals(symbol.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(Symbol o) {
        return this.name.compareTo(o.name);
    }
}

